/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.dynamo;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import io.github.devlibx.easy.database.IDatabaseService;
import io.github.devlibx.easy.database.dynamo.DataSourceFactory;
import io.github.devlibx.easy.database.dynamo.config.DynamoConfigs;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseService
implements IDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(DatabaseService.class);
    private final DynamoConfigs dbConfigs;
    private final DataSourceFactory dataSourceFactory;

    @Inject
    public DatabaseService(DynamoConfigs dynamoConfigs, DataSourceFactory dataSourceFactory) {
        this.dbConfigs = dynamoConfigs;
        this.dataSourceFactory = dataSourceFactory;
    }

    public void startDatabase() {
        if (this.dbConfigs == null || this.dbConfigs.getConfigs() == null || this.dbConfigs.getConfigs().isEmpty()) {
            throw new RuntimeException("DynamoConfigs is null or empty. (If using Guice) Please check if you forgot to call bind(DynamoConfigs.class).toInstance(yourConfigs)");
        }
        this.dbConfigs.getConfigs().forEach((name, dynamoConfig) -> {
            AmazonDynamoDB client = (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(dynamoConfig.getEndPoint(), dynamoConfig.getRegion()))).build();
            DynamoDB dynamoDB = new DynamoDB(client);
            this.dataSourceFactory.add((String)name, dynamoDB);
        });
        log.info("DynamoDB setup completed...");
    }

    public void stopDatabase() {
    }
}

