/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.mysql;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import com.zaxxer.hikari.HikariDataSource;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.github.devlibx.easy.database.mysql.transaction.TransactionContext;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Named;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class DataSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(DataSourceFactory.class);
    private final Map<String, DataSource> dataSourceMap;
    private final boolean transactionAwareDatasource;
    private boolean initialized = false;
    private final Object LOCK = new Object();

    @Inject
    public DataSourceFactory(@Named(value="enable-transaction-aware-datasource") boolean transactionAwareDatasource) {
        this.transactionAwareDatasource = transactionAwareDatasource;
        this.dataSourceMap = new HashMap<String, DataSource>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(DataSource dataSource) {
        this.installMetricRegistry(dataSource);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.transactionAwareDatasource) {
                this.dataSourceMap.put("default", (DataSource)new TransactionAwareDataSourceProxy(dataSource));
            } else {
                this.dataSourceMap.put("default", dataSource);
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String dataSourceName, DataSource dataSource) {
        this.installMetricRegistry(dataSource);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.transactionAwareDatasource) {
                this.dataSourceMap.put(dataSourceName, (DataSource)new TransactionAwareDataSourceProxy(dataSource));
            } else {
                this.dataSourceMap.put(dataSourceName, dataSource);
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialization() {
        if (!this.initialized) {
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.initialized) {
                    throw new RuntimeException("Datasource(s) are not initialized as of now. You must call IDatabaseService.startDatabase() before requesting for datasource");
                }
            }
        }
    }

    public DataSource getDataSource(String dataSourceName) {
        this.ensureInitialization();
        return this.dataSourceMap.get(dataSourceName);
    }

    public DataSource getDataSource() {
        this.ensureInitialization();
        TransactionContext.Context context = TransactionContext.getInstance().getContext();
        if (context == null || Strings.isNullOrEmpty((String)context.getDatasourceName()) || Objects.equals("default", context.getDatasourceName())) {
            return this.dataSourceMap.get("default");
        }
        return this.dataSourceMap.get(context.getDatasourceName());
    }

    public void shutdown() {
        int count = this.dataSourceMap.size();
        AtomicLong closed = new AtomicLong();
        this.dataSourceMap.forEach((name, dataSource) -> {
            TransactionAwareDataSourceProxy proxy;
            DataSource underLyingDataSource;
            log.info("Close Datasource Begin: {}", name);
            if (dataSource instanceof HikariDataSource) {
                ((HikariDataSource)dataSource).close();
                closed.incrementAndGet();
            } else if (dataSource instanceof TransactionAwareDataSourceProxy && (underLyingDataSource = (proxy = (TransactionAwareDataSourceProxy)dataSource).getTargetDataSource()) instanceof HikariDataSource) {
                ((HikariDataSource)underLyingDataSource).close();
                closed.incrementAndGet();
            }
        });
        this.dataSourceMap.clear();
        if (closed.get() != (long)count) {
            throw new RuntimeException("We had " + count + " datasource registered, but only " + closed.get() + " are closed. This will cause connection leak. Please check.");
        }
    }

    private void installMetricRegistry(DataSource dataSource) {
        try {
            MetricRegistry metricRegistry = (MetricRegistry)ApplicationContext.getInstance(MetricRegistry.class);
            if (metricRegistry == null) {
                log.warn("MetricRegistry is not found - we will not register metric for datasource");
                return;
            }
            if (dataSource instanceof HikariDataSource) {
                HikariDataSource _dataSource = (HikariDataSource)dataSource;
                _dataSource.setMetricRegistry((Object)metricRegistry);
                log.warn("MetricRegistry registered: dataSource={}, metricRegistry={}", (Object)_dataSource, (Object)metricRegistry);
            } else {
                log.warn("MetricRegistry is not found - we will not register metric for datasource (only HikariDataSource is supported)");
            }
        }
        catch (Throwable e) {
            log.warn("Failed to register metric for datasource: datasource={}", (Object)dataSource, (Object)e);
        }
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }
}

