/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.mysql;

import io.github.devlibx.easy.database.IDatabaseService;
import io.github.devlibx.easy.database.mysql.DataSourceFactory;
import io.github.devlibx.easy.database.mysql.config.MySqlConfigs;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseService
implements IDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(DatabaseService.class);
    private final MySqlConfigs dbConfigs;
    private final DataSourceFactory dataSourceFactory;

    @Inject
    public DatabaseService(MySqlConfigs dbConfigs, DataSourceFactory dataSourceFactory) {
        this.dbConfigs = dbConfigs;
        this.dataSourceFactory = dataSourceFactory;
    }

    public void startDatabase() {
        if (this.dbConfigs == null || this.dbConfigs.getConfigs() == null || this.dbConfigs.getConfigs().isEmpty()) {
            throw new RuntimeException("MySqlConfigs is null or empty. (If using Guice) Please check if you forgot to call bind(MySqlConfigs.class).toInstance(yourConfigs)");
        }
        this.dbConfigs.getConfigs().forEach((name, mySqlConfig) -> this.dataSourceFactory.register((String)name, (DataSource)mySqlConfig.buildHikariDataSource()));
    }

    public void stopDatabase() {
        this.dataSourceFactory.shutdown();
    }
}

