/*
 * Decompiled with CFR 0.152.
 */
package ru.proninyaroslav.template;

import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import ru.proninyaroslav.template.Node;
import ru.proninyaroslav.template.Template;
import ru.proninyaroslav.template.Utils;
import ru.proninyaroslav.template.exceptions.ExecException;

class Exec {
    private static final int maxExecDepth = 1500;
    private Template tmpl;
    private Node node;
    private ArrayList<Template.Variable> vars;
    private int depth;
    private int forDepth;
    PrintWriter pw;

    Exec(Template tmpl, PrintWriter pw, ArrayList<Template.Variable> vars) {
        this.tmpl = tmpl;
        this.pw = pw;
        this.vars = vars;
    }

    private Exec(Exec s) {
        this.tmpl = s.tmpl;
        this.pw = s.pw;
        this.node = s.node;
        this.vars = s.vars;
        this.depth = s.depth;
    }

    void errorf(String format, Object ... args) throws ExecException {
        String name = Utils.doublePercent(this.tmpl.name);
        if (this.node == null) {
            format = String.format("template: %s: %s", name, String.format(format, args));
        } else {
            String location = this.tmpl.tree.errorLocation(this.node);
            String context = this.tmpl.tree.errorContext(this.node);
            format = String.format("template: %s: executing %s at <%s>: %s", location, name, Utils.doublePercent(context), String.format(format, args));
        }
        throw new ExecException(format);
    }

    private void push(String name, Object value) {
        this.vars.add(new Template.Variable(name, value));
    }

    private void pop(int mark) {
        this.vars = new ArrayList<Template.Variable>(this.vars.subList(0, mark));
    }

    private int stackSize() {
        return this.vars.size();
    }

    private void setTopVar(int n, Object value) {
        this.vars.get((int)(this.vars.size() - n)).value = value;
    }

    private void setVar(String name, Object value) throws ExecException {
        for (int i = this.stackSize() - 1; i >= 0; --i) {
            if (!this.vars.get((int)i).name.equals(name)) continue;
            this.vars.get((int)i).value = value;
            return;
        }
        this.errorf("undefined variable: %s", name);
    }

    private Object varValue(String name) throws ExecException {
        for (int i = this.vars.size() - 1; i >= 0; --i) {
            if (!this.vars.get((int)i).name.equals(name)) continue;
            return this.vars.get((int)i).value;
        }
        this.errorf("undefined variable: %s", name);
        return null;
    }

    private void at(Node node) {
        this.node = node;
    }

    private void printValue(Object value) {
        if (value != null && value.getClass().isArray()) {
            int length = Array.getLength(value);
            Object[] arr = new Object[length];
            for (int i = 0; i < length; ++i) {
                arr[i] = Array.get(value, i);
            }
            this.pw.print(Arrays.deepToString(arr));
        } else {
            this.pw.print(value);
        }
    }

    private void notAFunction(List<Node> args, Object finalVal) throws ExecException {
        if (args != null && (args.size() > 1 || finalVal != null)) {
            this.errorf("can't give argument to non-function %s", args.get(0));
        }
    }

    private Object constant(Node.Number num) {
        this.at(num);
        if (num.isFloat && !Utils.isHexConstant(num.text) && Utils.containsAny(num.text, ".eE")) {
            return num.floatVal;
        }
        if (num.isInt) {
            return num.intVal;
        }
        return null;
    }

    ForControl walk(Object dot, Node node) throws ExecException {
        this.at(node);
        if (node instanceof Node.Action) {
            Node.Action nodeAction = (Node.Action)node;
            Object val = this.evalPipeline(dot, nodeAction.pipe);
            if (nodeAction.pipe.vars.size() == 0) {
                this.printValue(val);
            }
        } else {
            if (node instanceof Node.If) {
                Node.If nodeIf = (Node.If)node;
                return this.walkIfOrWith(Node.Type.IF, dot, nodeIf.pipe, nodeIf.list, nodeIf.elseList);
            }
            if (node instanceof Node.List) {
                for (Node n : ((Node.List)node).nodes) {
                    ForControl c = this.walk(dot, n);
                    if (c == ForControl.NONE) continue;
                    return c;
                }
            } else {
                if (node instanceof Node.For) {
                    return this.walkFor(dot, (Node.For)node);
                }
                if (node instanceof Node.Template) {
                    this.walkTemplate(dot, (Node.Template)node);
                } else if (node instanceof Node.Text) {
                    this.pw.write(((Node.Text)node).text);
                } else {
                    if (node instanceof Node.With) {
                        Node.With nodeWith = (Node.With)node;
                        return this.walkIfOrWith(Node.Type.WITH, dot, nodeWith.pipe, nodeWith.list, nodeWith.elseList);
                    }
                    if (node instanceof Node.Break) {
                        if (this.forDepth == 0) {
                            this.errorf("invalid break outside of for", new Object[0]);
                        }
                        return ForControl.BREAK;
                    }
                    if (node instanceof Node.Continue) {
                        if (this.forDepth == 0) {
                            this.errorf("invalid continue outside of for", new Object[0]);
                        }
                        return ForControl.CONTINUE;
                    }
                    this.errorf("unknown node: %s", node);
                }
            }
        }
        return ForControl.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ForControl walkIfOrWith(Node.Type type, Object dot, Node.Pipe pipe, Node.List list, Node.List elseList) throws ExecException {
        int stackSize = this.stackSize();
        try {
            Object val = this.evalPipeline(dot, pipe);
            boolean truth = false;
            try {
                truth = Utils.isTrue(val);
            }
            catch (IllegalArgumentException e) {
                this.errorf("if/with can't use %s", val);
            }
            if (truth) {
                if (type == Node.Type.WITH) {
                    ForControl forControl = this.walk(val, list);
                    return forControl;
                }
                ForControl forControl = this.walk(dot, list);
                return forControl;
            }
            if (elseList != null) {
                ForControl forControl = this.walk(dot, elseList);
                return forControl;
            }
        }
        finally {
            this.pop(stackSize);
        }
        return ForControl.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ForControl walkFor(Object dot, Node.For f) throws ExecException {
        this.at(f);
        int stackSize = this.stackSize();
        try {
            Object val = this.evalPipeline(dot, f.pipe);
            int startStackSize = this.stackSize();
            ++this.forDepth;
            if (val != null) {
                if (Iterable.class.isInstance(val)) {
                    Iterator i = ((Iterable)val).iterator();
                    if (i.hasNext()) {
                        while (i.hasNext() && this.forIteration(f, i.next(), startStackSize) != ForControl.BREAK) {
                        }
                        --this.forDepth;
                        ForControl forControl = ForControl.NONE;
                        return forControl;
                    }
                } else if (val.getClass().isArray()) {
                    int length = Array.getLength(val);
                    if (length > 0) {
                        for (int i = 0; i < length && this.forIteration(f, Array.get(val, i), startStackSize) != ForControl.BREAK; ++i) {
                        }
                        --this.forDepth;
                        ForControl forControl = ForControl.NONE;
                        return forControl;
                    }
                } else {
                    this.errorf("for can't iterable over %s", val);
                }
            }
            --this.forDepth;
            if (f.elseList != null) {
                ForControl forControl = this.walk(dot, f.elseList);
                return forControl;
            }
        }
        finally {
            this.pop(stackSize);
        }
        return ForControl.NONE;
    }

    private ForControl forIteration(Node.For f, Object elem, int startStackSize) throws ExecException {
        if (f.pipe.vars.size() == 1) {
            this.setTopVar(1, elem);
        }
        ForControl c = this.walk(elem, f.list);
        this.pop(startStackSize);
        return c;
    }

    private void walkTemplate(Object dot, Node.Template template) throws ExecException {
        this.at(template);
        Template tmpl = this.tmpl.common.tmpl.get(template.name);
        if (tmpl == null) {
            this.errorf("template %s not defined", template.name);
            return;
        }
        if (this.depth == 1500) {
            this.errorf("exceeded maximum template depth (%d)", 1500);
        }
        dot = this.evalPipeline(dot, template.pipe);
        Exec newState = new Exec(this);
        ++newState.depth;
        newState.tmpl = tmpl;
        newState.vars = new ArrayList();
        newState.vars.add(new Template.Variable("$", dot));
        newState.walk(dot, tmpl.tree.root);
    }

    private Object evalPipeline(Object dot, Node.Pipe pipe) throws ExecException {
        if (pipe == null) {
            return null;
        }
        this.at(pipe);
        Object val = null;
        for (Node.Command cmd : pipe.cmds) {
            val = this.evalCommand(dot, cmd, val);
        }
        for (Node.Assign var : pipe.vars) {
            if (pipe.decl) {
                this.push(var.ident.get(0), val);
                continue;
            }
            this.setVar(var.ident.get(0), val);
        }
        return val;
    }

    private Object evalCommand(Object dot, Node.Command cmd, Object finalVal) throws ExecException {
        Node firstWord = cmd.args.get(0);
        if (firstWord instanceof Node.Field) {
            return this.evalFieldNode(dot, (Node.Field)firstWord, cmd.args, finalVal);
        }
        if (firstWord instanceof Node.Chain) {
            return this.evalChainNode(dot, (Node.Chain)firstWord, cmd.args, finalVal);
        }
        if (firstWord instanceof Node.Identifier) {
            return this.evalFunction(dot, (Node.Identifier)firstWord, cmd, cmd.args, finalVal);
        }
        if (firstWord instanceof Node.Pipe) {
            return this.evalPipeline(dot, (Node.Pipe)firstWord);
        }
        if (firstWord instanceof Node.Assign) {
            return this.evalVariableNode(dot, (Node.Assign)firstWord, cmd.args, finalVal);
        }
        this.at(firstWord);
        this.notAFunction(cmd.args, finalVal);
        if (firstWord instanceof Node.Bool) {
            return ((Node.Bool)firstWord).boolVal;
        }
        if (firstWord instanceof Node.Dot) {
            return dot;
        }
        if (firstWord instanceof Node.Null) {
            this.errorf("null is not a command", new Object[0]);
        } else {
            if (firstWord instanceof Node.Number) {
                return this.constant((Node.Number)firstWord);
            }
            if (firstWord instanceof Node.StringConst) {
                return ((Node.StringConst)firstWord).text;
            }
        }
        this.errorf("can't evaluate command %s", firstWord);
        return null;
    }

    private Object evalFieldNode(Object dot, Node.Field field, List<Node> args, Object finalVal) throws ExecException {
        this.at(field);
        return this.evalFieldChain(dot, dot, field, field.ident, args, finalVal);
    }

    private Object evalChainNode(Object dot, Node.Chain chain, List<Node> args, Object finalVal) throws ExecException {
        this.at(chain);
        if (chain == null) {
            this.errorf("indirection through explicit null in %s", new Object[0]);
            return null;
        }
        if (chain.field.size() == 0) {
            this.errorf("internal error: no fields in evalChainNode", new Object[0]);
            return null;
        }
        Object pipe = this.evalArg(dot, chain.node);
        return this.evalFieldChain(dot, pipe, chain, chain.field, args, finalVal);
    }

    private Object evalArg(Object dot, Node node) throws ExecException {
        this.at(node);
        if (node instanceof Node.Dot) {
            return dot;
        }
        if (node instanceof Node.Null) {
            return null;
        }
        if (node instanceof Node.Field) {
            ArrayList<Node> args = new ArrayList<Node>();
            args.add(node);
            return this.evalFieldNode(dot, (Node.Field)node, args, null);
        }
        if (node instanceof Node.Assign) {
            return this.evalVariableNode(dot, (Node.Assign)node, null, null);
        }
        if (node instanceof Node.Pipe) {
            return this.evalPipeline(dot, (Node.Pipe)node);
        }
        if (node instanceof Node.Identifier) {
            return this.evalFunction(dot, (Node.Identifier)node, node, null, null);
        }
        if (node instanceof Node.Chain) {
            return this.evalChainNode(dot, (Node.Chain)node, null, null);
        }
        if (node instanceof Node.Bool) {
            return ((Node.Bool)node).boolVal;
        }
        if (node instanceof Node.Number) {
            return this.constant((Node.Number)node);
        }
        if (node instanceof Node.StringConst) {
            return ((Node.StringConst)node).text;
        }
        this.errorf("can't handle %s for arg", node);
        return null;
    }

    private Object evalFieldChain(Object dot, Object receiver, Node node, List<String> ident, List<Node> args, Object finalVal) throws ExecException {
        int n = ident.size();
        for (int i = 0; i < n - 1; ++i) {
            receiver = this.evalField(dot, ident.get(i), node, null, null, receiver);
        }
        return this.evalField(dot, ident.get(n - 1), node, args, finalVal, receiver);
    }

    private Object evalField(Object dot, String fieldName, Node node, List<Node> args, Object finalVal, Object receiver) throws ExecException {
        ArrayList<Method> foundMethods;
        boolean hasArgs;
        Field field;
        block12: {
            if (receiver == null) {
                this.errorf("null pointer evaluating null.%s", fieldName);
                return null;
            }
            if (receiver.getClass().isArray() && fieldName.equals("length")) {
                return Array.getLength(receiver);
            }
            Method[] methods = receiver.getClass().getDeclaredMethods();
            field = null;
            hasArgs = args != null && (args.size() > 1 || finalVal != null);
            foundMethods = new ArrayList<Method>();
            for (Method method : methods) {
                if (!method.getName().equals(fieldName)) continue;
                foundMethods.add(method);
            }
            try {
                field = receiver.getClass().getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException | SecurityException e) {
                if (!foundMethods.isEmpty()) break block12;
                this.errorf("can't evaluate field %s in class %s", fieldName, receiver.getClass().getName());
            }
        }
        if (field != null && !foundMethods.isEmpty()) {
            this.errorf("type %s has both field and method named %s", receiver.getClass().toString(), fieldName);
            return null;
        }
        if (!foundMethods.isEmpty()) {
            return this.evalCall(dot, foundMethods, node, fieldName, args, finalVal, receiver);
        }
        if (field != null) {
            if (hasArgs) {
                this.errorf("%s has arguments but cannot be invoked as method", fieldName);
                return null;
            }
            try {
                return field.get(receiver);
            }
            catch (IllegalAccessException e) {
                this.errorf("%s is a non-public field of class %s", fieldName, receiver.getClass().getName());
            }
            catch (IllegalArgumentException e) {
                this.errorf("can't evaluate field %s in class %s", fieldName, receiver.getClass().getName());
            }
        }
        return null;
    }

    private Object evalFunction(Object dot, Node.Identifier node, Node cmd, List<Node> args, Object finalVal) throws ExecException {
        String name = node.ident;
        List<Method> func = this.tmpl.findFunc(name);
        if (func == null) {
            this.errorf("%s is not a defined function", name);
            return null;
        }
        return this.evalCall(dot, func, cmd, name, args, finalVal, null);
    }

    private Object evalCall(Object dot, List<Method> func, Node node, String name, List<Node> args, Object finalVal, Object receiver) throws ExecException {
        if (args != null) {
            args = new ArrayList<Node>(args.subList(1, args.size()));
        }
        int numArgs = args != null ? args.size() : 0;
        ArrayList<Object> argv = new ArrayList<Object>();
        if (receiver != null) {
            argv.add(receiver);
        }
        for (int i = 0; i < numArgs; ++i) {
            argv.add(this.evalArg(dot, args.get(i)));
        }
        if (finalVal != null) {
            argv.add(finalVal);
        }
        Object result = null;
        ArrayList<String> err = new ArrayList<String>();
        String errFmt = "\n(%s): %s";
        for (Method m : func) {
            if (m.getReturnType() == Void.TYPE) {
                err.add(String.format(errFmt, m, "can't call method/function with void return type"));
                continue;
            }
            try {
                MethodHandle mh = MethodHandles.lookup().unreflect(m);
                result = mh.invokeWithArguments(argv);
            }
            catch (Throwable e) {
                if (e instanceof NullPointerException) {
                    err.add(String.format(errFmt, m, "assign null to primitive type"));
                    continue;
                }
                err.add(String.format(errFmt, m, e));
            }
        }
        if (result == null && !err.isEmpty()) {
            this.at(node);
            StringBuilder sb = new StringBuilder("error calling " + name + ":");
            for (String e : err) {
                sb.append(e);
            }
            this.errorf(sb.toString(), new Object[0]);
        }
        return result;
    }

    private Object evalVariableNode(Object dot, Node.Assign var, List<Node> args, Object finalVal) throws ExecException {
        this.at(var);
        Object val = this.varValue(var.ident.get(0));
        int size = var.ident.size();
        if (size == 1) {
            this.notAFunction(args, finalVal);
            return val;
        }
        return this.evalFieldChain(dot, val, var, var.ident.subList(1, size), args, finalVal);
    }

    static enum ForControl {
        NONE,
        BREAK,
        CONTINUE;

    }
}

