/*
 * Decompiled with CFR 0.152.
 */
package ru.proninyaroslav.template;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.proninyaroslav.template.BuiltinsFuncs;

public class FuncMap {
    private HashMap<String, List<Method>> funcs = new HashMap();
    static FuncMap builtins = BuiltinsFuncs.create();

    public void put(String alias, String methodName, Class c) {
        this.findAndPut(alias, methodName, c.getMethods());
    }

    public void put(Map<String, String> aliasToName, Class c) {
        Method[] methods = c.getMethods();
        for (Map.Entry<String, String> i : aliasToName.entrySet()) {
            this.findAndPut(i.getKey(), i.getValue(), methods);
        }
    }

    public void put(FuncMap funcMap) {
        this.funcs.putAll(funcMap.funcs);
    }

    public List<Method> get(String alias) {
        return this.funcs.get(alias);
    }

    public boolean contains(String alias) {
        return this.get(alias) != null;
    }

    public Map<String, List<Method>> getAll() {
        return this.funcs;
    }

    private void findAndPut(String alias, String methodName, Method[] methods) {
        ArrayList<Method> found = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(methodName) || !Modifier.isStatic(method.getModifiers())) continue;
            found.add(method);
        }
        if (found.isEmpty()) {
            throw new IllegalArgumentException(String.format("method '%s' not found, not static or non-public", methodName));
        }
        this.funcs.put(alias, found);
    }
}

