/*
 * Decompiled with CFR 0.152.
 */
package ru.proninyaroslav.template;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import ru.proninyaroslav.template.Exec;
import ru.proninyaroslav.template.FileUtils;
import ru.proninyaroslav.template.FuncMap;
import ru.proninyaroslav.template.Tree;
import ru.proninyaroslav.template.Utils;
import ru.proninyaroslav.template.exceptions.ExecException;
import ru.proninyaroslav.template.exceptions.InternalException;
import ru.proninyaroslav.template.exceptions.ParseException;

public class Template {
    String name;
    private String leftDelim;
    private String rightDelim;
    Tree tree;
    Common common;

    public Template(String name) {
        this.name = name;
        this.common = new Common();
    }

    public Template(String name, Template parent) {
        this.name = name;
        this.common = parent.common;
        this.leftDelim = parent.leftDelim;
        this.rightDelim = parent.rightDelim;
    }

    public void parse(String text) throws InternalException, ParseException {
        HashMap<String, Tree> trees;
        this.common.funcsLock.lock();
        try {
            trees = Tree.parse(this.name, text, this.leftDelim, this.rightDelim, this.common.funcs, FuncMap.builtins);
        }
        finally {
            this.common.funcsLock.unlock();
        }
        for (String name : trees.keySet()) {
            this.addParseTree(name, trees.get(name));
        }
    }

    public void parse(InputStream input) throws InternalException, ParseException, IOException {
        this.parse(new String(FileUtils.toByteArray(input)));
    }

    public static Template parse(FuncMap funcs, File ... files) throws ParseException, IOException {
        if (files.length == 0) {
            throw new ParseException("no files");
        }
        return Template.parse(null, funcs, Utils.filesToString(files));
    }

    public static Template parse(FuncMap funcs, Map<String, String> inputs) throws ParseException {
        if (inputs.size() == 0) {
            throw new ParseException("no inputs");
        }
        return Template.parse(null, funcs, inputs);
    }

    public Template parseTo(FuncMap funcs, File ... files) throws ParseException, IOException {
        if (files.length == 0) {
            throw new ParseException("no files");
        }
        return Template.parse(this, funcs, Utils.filesToString(files));
    }

    public Template parseTo(FuncMap funcs, Map<String, String> text) throws ParseException {
        if (text.size() == 0) {
            throw new ParseException("no inputs");
        }
        return Template.parse(this, funcs, text);
    }

    private static Template parse(Template t, FuncMap funcs, Map<String, String> inputs) throws ParseException {
        if (inputs.size() == 0) {
            throw new ParseException("no text data");
        }
        for (Map.Entry<String, String> text : inputs.entrySet()) {
            try {
                String name = text.getKey();
                if (t == null) {
                    t = new Template(name);
                    if (funcs != null) {
                        t.addFuncs(funcs);
                    }
                }
                Template tmpl = name.equals(t.name) ? t : new Template(name, t);
                tmpl.parse(text.getValue());
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OutputStream os, Object data) throws ExecException {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(new Variable("$", data));
        Exec state = new Exec(this, new PrintWriter(os), vars);
        try {
            if (this.tree == null || this.tree.root == null) {
                state.errorf("%s is an incomplete or empty template", this.name);
            }
            state.walk(data, this.tree.root);
        }
        finally {
            state.pw.close();
        }
    }

    public void executeTemplate(OutputStream os, String name, Object data) throws ExecException {
        Template tmpl = null;
        if (this.common != null) {
            tmpl = this.common.tmpl.get(name);
        }
        if (tmpl == null) {
            throw new ExecException(String.format("no template %s associated with template %s", name, this.name));
        }
        tmpl.execute(os, data);
    }

    public void addFuncs(FuncMap funcs) {
        if (funcs == null) {
            throw new NullPointerException();
        }
        this.common.funcsLock.lock();
        try {
            this.common.funcs.put(funcs);
        }
        finally {
            this.common.funcsLock.unlock();
        }
    }

    public void setDelims(String left, String right) {
        this.leftDelim = left;
        this.rightDelim = right;
    }

    public Template[] getTemplates() {
        if (this.common == null) {
            return null;
        }
        return this.common.tmpl.values().toArray(new Template[this.common.tmpl.size()]);
    }

    public Template getTemplate(String name) {
        if (this.common == null) {
            return null;
        }
        return this.common.tmpl.get(name);
    }

    public void addParseTree(String name, Tree tree) throws InternalException, ParseException {
        Template newTemplate = this;
        if (!name.equals(this.name)) {
            newTemplate = new Template(name, this);
        }
        if (this.associate(newTemplate, tree) || newTemplate.tree == null) {
            newTemplate.tree = tree;
        }
    }

    private boolean associate(Template newTemplate, Tree tree) throws InternalException, ParseException {
        if (newTemplate.common != this.common) {
            throw new InternalException("associate not common");
        }
        Template old = this.common.tmpl.get(newTemplate.name);
        if (old != null && Tree.isEmptyTree(tree.root) && old.tree != null) {
            return false;
        }
        this.common.tmpl.put(newTemplate.name, newTemplate);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Method> findFunc(String name) {
        this.common.funcsLock.lock();
        try {
            List<Method> func = this.common.funcs.get(name);
            if (func != null) {
                List<Method> list = func;
                return list;
            }
        }
        finally {
            this.common.funcsLock.unlock();
        }
        return FuncMap.builtins.get(name);
    }

    static class Variable {
        String name;
        Object value;

        Variable(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    class Common {
        FuncMap funcs;
        final ReentrantLock funcsLock = new ReentrantLock();
        HashMap<String, Template> tmpl = new HashMap();

        Common() {
            this.funcs = new FuncMap();
        }
    }
}

