package io.github.endreman0.javajson.nodes;

/**
 * A JSON boolean node has two possible values: {@code true} and {@code false}.
 * While an infinite number of boolean nodes can be created, one (and exactly one) of {@code equals(new BooleanNode(true))} and
 * {@code equals(new BooleanNode(false))} will return true. 
 * @author endreman0
 */
public class BooleanNode extends Node{
	private boolean value;
	/**
	 * Creates a new boolean node with the default value false.
	 */
	public BooleanNode(){this(false);}
	/**
	 * Creates a new boolean node with the specified value.
	 * @param value The node's value
	 */
	public BooleanNode(boolean value){super(); set(value);}
	/**
	 * Set the value of this node.
	 * @param value This node's new value
	 * @return {@code this}, for chaining
	 */
	public BooleanNode set(boolean value){this.value = value; return this;}
	/**
	 * Get the value of this node.
	 * @return This node's value
	 */
	public boolean get(){return value;}
	@Override public boolean equals(Object obj){return obj instanceof BooleanNode && ((BooleanNode)obj).value == value;}
	@Override public int hashCode(){return value ? 1 : 0;}
	@Override public String toString(){return String.valueOf(value);}
}
