package io.github.endreman0.javajson.nodes;

/**
 * All JSON nodes have a few properties in common.
 * <ul>
 * <li>They all have a parent node, and</li>
 * <li>Given another node with the same values and/or children, the two nodes will be considered equal.</li>
 * </ul>
 * @author endreman0
 */
public abstract class Node{
	protected ParentNode parent;
	protected Node(){}
	/**
	 * Remove this node from its parent.
	 */
	public void remove(){if(parent != null) parent.remove(this);}
	/**
	 * Get the parent of this node.
	 * @return the node's parent
	 */
	public ParentNode parent(){return parent;}
	@Override public abstract String toString();
	@Override public abstract boolean equals(Object obj);
	@Override public abstract int hashCode();
}
