package io.github.endreman0.javajson.nodes;

/**
 * A JSON null node has no values or children, but can be used as a node. Just like Java's {@code null}, there's not a lot you can do with
 * a null node.
 * An infinite number of null nodes can be created, but they are all the same. For any null node, {@code equals(new NullNode)} will always
 * return true.
 * @author endreman0
 */
public class NullNode extends Node{
	@Override public String toString(){return "null";}
	@Override public boolean equals(Object obj){return obj instanceof NullNode;}
	@Override public int hashCode(){return 39275;}//Pseudorandom numeric keyboard smash so that all NullNodes are equal.
}
