package io.github.endreman0.javajson.nodes;

/**
 * A JSON number node contains one number, represented in Java as a double.
 * Any two number nodes with the same value are considered equal.
 * @author endreman0
 */
public class NumberNode extends Node{
	private double value;
	/**
	 * Create a new number node with the default value of 0.
	 */
	public NumberNode(){this(0);}
	/**
	 * Creates a new number node with the specified value.
	 * @param value The node's value
	 */
	public NumberNode(double value){super();set(value);}
	/**
	 * Set the value of this node.
	 * @param value This node's new value
	 * @return {@code this}, for chaining
	 */
	public NumberNode set(double value){this.value = value; return this;}
	/**
	 * Get the value of this node.
	 * @return This node's value
	 */
	public double get(){return value;}
	@Override public boolean equals(Object obj){return obj instanceof NumberNode && ((NumberNode)obj).value == value;}
	@Override public int hashCode(){return (int)value;}
	@Override public String toString(){return String.valueOf(value);}
}
