package io.github.endreman0.javajson.nodes;

public abstract class ParentNode extends Node{
	protected ParentNode(){super();}
	/**
	 * Remove the specified node from this node's children.
	 * @param node The node to remove
	 * @return whether the node was a child of this node before removal
	 */
	public abstract boolean remove(Node node);
	/**
	 * Remove all child nodes from this node.
	 */
	public abstract void removeAll();
	/**
	 * Get the number of child nodes this node has.
	 * @return The number of child nodes
	 */
	public abstract int size();
	/**
	 * Get whether the node is a child of this node.
	 * @param node The node to search for
	 * @return {@code true} if the node was found, {@code false} if not
	 */
	public abstract boolean contains(Node node);
}
