package io.github.endreman0.javajson.nodes;

/**
 * A JSON string node contains one string.
 * Any two string nodes with the same value are considered equal.
 * @author endreman0
 */
public class StringNode extends Node{
	private String value;
	/**
	 * Create a new string node with the default value of an empty string.
	 */
	public StringNode(){this("");}
	/**
	 * Creates a new string node with the specified value.
	 * @param value The node's value
	 */
	public StringNode(String value){super(); set(value);}
	/**
	 * Set the value of this node.
	 * @param value This node's new value
	 * @return {@code this}, for chaining
	 */
	public StringNode set(String value){this.value = value; return this;}
	/**
	 * Get the value of this node.
	 * @return This node's value
	 */
	public String get(){return value;}
	@Override public boolean equals(Object obj){return obj instanceof StringNode && ((StringNode)obj).value.equals(value);}
	@Override public int hashCode(){return value.hashCode();}
	@Override public String toString(){return "\"" + value + "\"";}
}
