/*
 * Decompiled with CFR 0.152.
 */
package io.github.endreman0.javajson.nodes;

import io.github.endreman0.javajson.nodes.BooleanNode;
import io.github.endreman0.javajson.nodes.Node;
import io.github.endreman0.javajson.nodes.NumberNode;
import io.github.endreman0.javajson.nodes.ObjectNode;
import io.github.endreman0.javajson.nodes.ParentNode;
import io.github.endreman0.javajson.nodes.StringNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayNode
extends ParentNode
implements Iterable<Node> {
    private List<Node> children = new ArrayList<Node>();

    public ArrayNode() {
    }

    public ArrayNode(Node ... children) {
        this();
        this.addAll(children);
    }

    public ArrayNode(Iterable<Node> children) {
        this();
        this.addAll(children);
    }

    public ArrayNode add(Node node) {
        if (node != null) {
            this.children.add(node);
            node.parent = this;
        }
        return this;
    }

    public ArrayNode add(int index, Node node) {
        this.children.add(index, node);
        node.parent = this;
        return this;
    }

    public ArrayNode addAll(Node ... nodes) {
        for (Node node : nodes) {
            this.add(node);
        }
        return this;
    }

    public ArrayNode addAll(Iterable<Node> nodes) {
        for (Node node : nodes) {
            this.add(node);
        }
        return this;
    }

    public ArrayNode addAll(int index, Node ... nodes) {
        for (Node node : nodes) {
            this.add(index++, node);
        }
        return this;
    }

    public ArrayNode addAll(int index, Iterable<Node> nodes) {
        for (Node node : nodes) {
            this.add(index++, node);
        }
        return this;
    }

    public Node get(int index) {
        return this.children.get(index);
    }

    public ArrayNode getArray(int index) {
        Node node = this.get(index);
        if (node instanceof ArrayNode) {
            return (ArrayNode)node;
        }
        return null;
    }

    public BooleanNode getBoolean(int index) {
        Node node = this.get(index);
        if (node instanceof BooleanNode) {
            return (BooleanNode)node;
        }
        return null;
    }

    public NumberNode getNumber(int index) {
        Node node = this.get(index);
        if (node instanceof NumberNode) {
            return (NumberNode)node;
        }
        return null;
    }

    public ObjectNode getObject(int index) {
        Node node = this.get(index);
        if (node instanceof ObjectNode) {
            return (ObjectNode)node;
        }
        return null;
    }

    public StringNode getString(int index) {
        Node node = this.get(index);
        if (node instanceof StringNode) {
            return (StringNode)node;
        }
        return null;
    }

    public int indexOf(Node node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean contains(Node node) {
        return this.children.contains(node);
    }

    public Node remove(int index) {
        return this.children.remove(index);
    }

    @Override
    public boolean remove(Node node) {
        if (this.children.remove(node)) {
            node.parent = null;
            return true;
        }
        return false;
    }

    @Override
    public void removeAll() {
        this.children.clear();
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.children.iterator();
    }

    public ListIterator<Node> listIterator() {
        return this.children.listIterator();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ArrayNode)) {
            return false;
        }
        ArrayNode node = (ArrayNode)obj;
        if (this.size() != node.size()) {
            return false;
        }
        Iterator<Node> i1 = this.iterator();
        Iterator<Node> i2 = node.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        ListIterator<Node> i = this.children.listIterator();
        while (i.hasNext()) {
            if (i.nextIndex() % 2 == 1) {
                hashCode += i.next().hashCode();
                continue;
            }
            hashCode -= i.next().hashCode();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("[\r\n");
        Iterator<Node> i = this.iterator();
        while (i.hasNext()) {
            sb.append(" ").append(i.next().toString().replace("\n", "\n "));
            if (!i.hasNext()) continue;
            sb.append(",\r\n");
        }
        return sb.append("\r\n]").toString();
    }
}

