/*
 * Decompiled with CFR 0.152.
 */
package io.github.endreman0.javajson.nodes;

import io.github.endreman0.javajson.nodes.ArrayNode;
import io.github.endreman0.javajson.nodes.BooleanNode;
import io.github.endreman0.javajson.nodes.Node;
import io.github.endreman0.javajson.nodes.NumberNode;
import io.github.endreman0.javajson.nodes.ParentNode;
import io.github.endreman0.javajson.nodes.StringNode;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ObjectNode
extends ParentNode
implements Iterable<Map.Entry<String, Node>> {
    private Map<String, Node> children = new TreeMap<String, Node>();

    public ObjectNode() {
    }

    public ObjectNode(Iterable<Map.Entry<String, Node>> children) {
        this();
        this.putAll(children);
    }

    public ObjectNode put(String key, Node value) {
        this.children.put(key, value);
        value.parent = this;
        return this;
    }

    public ObjectNode putAll(Iterable<Map.Entry<String, Node>> children) {
        for (Map.Entry<String, Node> child : children) {
            this.put(child.getKey(), child.getValue());
        }
        return this;
    }

    public Node get(String key) {
        return this.children.get(key);
    }

    public ArrayNode getArray(String key) {
        Node node = this.get(key);
        if (node instanceof ArrayNode) {
            return (ArrayNode)node;
        }
        return null;
    }

    public BooleanNode getBoolean(String key) {
        Node node = this.get(key);
        if (node instanceof BooleanNode) {
            return (BooleanNode)node;
        }
        return null;
    }

    public NumberNode getNumber(String key) {
        Node node = this.get(key);
        if (node instanceof NumberNode) {
            return (NumberNode)node;
        }
        return null;
    }

    public ObjectNode getObject(String key) {
        Node node = this.get(key);
        if (node instanceof ObjectNode) {
            return (ObjectNode)node;
        }
        return null;
    }

    public StringNode getString(String key) {
        Node node = this.get(key);
        if (node instanceof StringNode) {
            return (StringNode)node;
        }
        return null;
    }

    public String keyOf(Node value) {
        for (Map.Entry<String, Node> entry : this.children.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    public boolean contains(String key) {
        return this.children.containsKey(key);
    }

    @Override
    public boolean contains(Node value) {
        return this.children.containsValue(value);
    }

    public Node remove(String key) {
        return this.children.remove(key);
    }

    @Override
    public boolean remove(Node value) {
        for (Map.Entry<String, Node> entry : this.children.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            this.children.remove(entry.getKey());
            value.parent = null;
            return true;
        }
        return false;
    }

    @Override
    public void removeAll() {
        this.children.clear();
    }

    @Override
    public Iterator<Map.Entry<String, Node>> iterator() {
        return this.children.entrySet().iterator();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectNode)) {
            return false;
        }
        ObjectNode node = (ObjectNode)obj;
        if (this.size() != node.size()) {
            return false;
        }
        Iterator<Map.Entry<String, Node>> i1 = this.iterator();
        Iterator<Map.Entry<String, Node>> i2 = node.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        boolean add = true;
        for (Map.Entry<String, Node> entry : this) {
            if (add = !add) {
                hashCode += entry.hashCode();
                continue;
            }
            hashCode -= entry.hashCode();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("{\r\n");
        Iterator<Map.Entry<String, Node>> i = this.iterator();
        while (i.hasNext()) {
            Map.Entry<String, Node> entry = i.next();
            sb.append(String.format(" \"%s\" : %s", entry.getKey(), entry.getValue()).replace("\n", "\n "));
            if (!i.hasNext()) continue;
            sb.append(",\r\n");
        }
        return sb.append("\r\n}").toString();
    }
}

