/*
 * Decompiled with CFR 0.152.
 */
package de.factoryfx.javascript.data.attributes.types;

import com.google.javascript.jscomp.parsing.parser.Keywords;
import de.factoryfx.javascript.data.attributes.types.Immutables;
import de.factoryfx.javascript.data.attributes.types.JSDoc;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class DeclareJavaInput {
    private HashSet<Class<?>> classesToBeDeclared = new HashSet();
    private HashMap<String, Class<?>> variablesToBeDeclared = new HashMap();
    private Immutables immutables = new Immutables();
    static final List<Class> primitiveNumbers = Arrays.asList(Float.TYPE, Double.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE);

    public DeclareJavaInput declareClasses(Class<?> ... clazz) {
        Stream.of(clazz).forEach(this::declareClass);
        return this;
    }

    public DeclareJavaInput declareClass(Class<?> clazz) {
        this.classesToBeDeclared.add(clazz);
        return this;
    }

    public DeclareJavaInput declareVariable(String name, Class<?> type) {
        this.variablesToBeDeclared.put(name, type);
        this.classesToBeDeclared.add(type);
        return this;
    }

    public String sourceScript() {
        StringBuilder source = new StringBuilder();
        HashSet classesAlreadyDeclared = new HashSet();
        this.classesToBeDeclared.forEach(c -> {
            if (!classesAlreadyDeclared.contains(c)) {
                this.declareClass(classesAlreadyDeclared, (Class<?>)c, source);
            }
        });
        this.variablesToBeDeclared.forEach((name, type) -> {
            source.append("/** @constant @readonly @type {!").append(this.toJsType((Class<?>)type)).append("} */\n");
            source.append("var ").append((String)name).append(";\n");
        });
        return source.toString();
    }

    private void declareClass(HashSet<Class<?>> classesAlreadyDeclared, Class<?> clazz, StringBuilder source) {
        classesAlreadyDeclared.add(clazz);
        String className = clazz.getSimpleName();
        String declProto = className + ".prototype.";
        String immutable = this.immutables.contains(clazz) ? " * @nosideeffects\n" : "";
        source.append("/**\n * @constructor\n * @struct\n").append(immutable);
        if (this.classesToBeDeclared.contains(clazz.getSuperclass())) {
            source.append(" * @extends ").append(clazz.getSuperclass().getSimpleName()).append("\n");
        }
        Stream.of(clazz.getInterfaces()).forEach(c -> {
            if (this.classesToBeDeclared.contains(c)) {
                source.append(" * @extends ").append(c.getSimpleName()).append("\n");
            }
        });
        source.append(" */\nfunction ").append(className).append("() {}\n");
        HashSet<Class> reachableClasses = new HashSet<Class>();
        for (Field f : clazz.getFields()) {
            if (f.getDeclaringClass() == Object.class || !this.allowTypeReference(f.getType())) continue;
            Class<?> closestType = this.getClosestType(f.getType()).orElse(f.getType());
            reachableClasses.add(closestType);
            int modifiers = f.getModifiers();
            boolean isNullable = f.isAnnotationPresent(Nullable.class);
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || Stream.of(Keywords.values()).anyMatch(kw -> kw.value.equals(f.getName()))) continue;
            source.append("/** ");
            JSDoc jsDoc = f.getAnnotation(JSDoc.class);
            if (jsDoc == null) {
                boolean isConstant;
                boolean bl = isConstant = Modifier.isFinal(modifiers) || closestType != f.getType();
                if (isConstant) {
                    source.append("@readonly @constant {");
                } else {
                    source.append("@type {");
                }
                if (!isNullable) {
                    source.append("!");
                }
                source.append(this.toJsType(closestType)).append("}");
            } else {
                source.append(jsDoc.value());
            }
            source.append(" */\n").append(declProto).append(f.getName());
            source.append(";\n");
        }
        Type t = clazz.getGenericSuperclass();
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            for (Type at : pt.getActualTypeArguments()) {
                if (!(at instanceof Class)) continue;
                reachableClasses.add((Class)at);
            }
        }
        List methods = Stream.of(clazz.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) && !Modifier.isStatic(m.getModifiers())).collect(Collectors.toList());
        for (String methodName : methods.stream().map(m -> m.getName()).distinct().collect(Collectors.toList())) {
            List matchingMethods = methods.stream().filter(m -> m.getName().equals(methodName) && this.shouldDeclareMethod((Method)m)).collect(Collectors.toList());
            if (matchingMethods.isEmpty()) continue;
            boolean ellipsis = matchingMethods.size() > 1;
            Function<Method, String> declareReturn = mthd -> {
                StringBuilder ret = new StringBuilder();
                if (mthd.getReturnType() != Void.TYPE && mthd.getReturnType() != Character.TYPE) {
                    boolean allowsNullableReturn;
                    ret.append(" * @suppress {externsValidation}\n");
                    ret.append(" * @return {");
                    boolean bl = allowsNullableReturn = mthd.getAnnotatedReturnType() != null && mthd.getAnnotatedReturnType().isAnnotationPresent(Nullable.class);
                    if (!allowsNullableReturn) {
                        ret.append("!");
                    }
                    Class<?> closestType = this.getClosestType(mthd.getReturnType()).orElse(mthd.getReturnType());
                    reachableClasses.add(closestType);
                    ret.append(this.toJsType(closestType));
                    ret.append("}\n");
                } else {
                    ret.append(" * @return {undefined}\n");
                }
                ret.append(immutable);
                return ret.toString();
            };
            Method method = (Method)matchingMethods.get(0);
            JSDoc jsDoc = method.getAnnotation(JSDoc.class);
            if (!ellipsis) {
                source.append("/**\n");
                if (jsDoc != null) {
                    source.append(" * ").append(jsDoc.value()).append("\n");
                } else {
                    source.append(declareReturn.apply(method));
                }
                source.append(" */\n");
                source.append(declProto).append(methodName).append(" = function(");
                if (method.getParameters().length > 0) {
                    for (Parameter parameter : method.getParameters()) {
                        boolean isNullable = parameter.isAnnotationPresent(Nullable.class);
                        JSDoc jsParam = parameter.getAnnotation(JSDoc.class);
                        if (jsParam != null) {
                            source.append(" /** @type ").append(jsParam.value()).append(" */ ");
                        } else {
                            Class<?> closestType = this.getClosestType(parameter.getType()).orElse(parameter.getType());
                            reachableClasses.add(closestType);
                            source.append(" /** @type {");
                            if (!isNullable) {
                                source.append("!");
                            }
                            source.append(this.toJsType(closestType)).append("} */ ");
                        }
                        String parameterName = "_" + parameter.getName();
                        source.append(parameterName).append(",");
                    }
                    source.setLength(source.length() - 1);
                }
                source.append(") { ");
                source.append("};\n");
                continue;
            }
            source.append("/**\n");
            if (jsDoc != null) {
                source.append(" * ").append(jsDoc.value()).append("\n");
            } else {
                source.append(" * @param {...*} params\n");
            }
            source.append(" */\n");
            source.append(declProto).append(methodName).append(" = function(params) { }\n");
        }
        source.append("\n");
        reachableClasses.removeAll(classesAlreadyDeclared);
        reachableClasses.removeIf(this::isBuiltIn);
        reachableClasses.removeIf(c -> c.isArray());
        reachableClasses.removeIf(c -> c.isPrimitive());
        reachableClasses.forEach(r -> {
            if (!classesAlreadyDeclared.contains(r)) {
                this.declareClass(classesAlreadyDeclared, (Class<?>)r, source);
            }
        });
    }

    private boolean shouldDeclareMethod(Method m) {
        return this.allowTypeReference(m.getDeclaringClass()) && (m.getAnnotation(JSDoc.class) != null || this.allowTypeReference(m.getReturnType()) && Stream.of(m.getParameters()).allMatch(this::allowParameter) && Stream.of(Keywords.values()).noneMatch(kw -> kw.value.equals(m.getName())));
    }

    private boolean allowParameter(Parameter parameter) {
        return parameter.isAnnotationPresent(JSDoc.class) || this.allowTypeReference(parameter.getType());
    }

    private boolean allowTypeReference(Class<?> type) {
        return !this.jsNameClash(type.getSimpleName()) && (this.isNumber(type) || CharSequence.class.isAssignableFrom(type) || this.classesToBeDeclared.stream().anyMatch(c -> c.isAssignableFrom(type)) || Void.TYPE == type || this.isBoolean(type));
    }

    private Optional<Class<?>> getClosestType(Class<?> type) {
        while (type != Object.class && type != null) {
            if (this.classesToBeDeclared.contains(type)) {
                return Optional.of(type);
            }
            for (Class iface : Optional.ofNullable(type.getInterfaces()).orElse(new Class[0])) {
                if (!this.classesToBeDeclared.contains(iface)) continue;
                return Optional.of(iface);
            }
            type = type.getSuperclass();
        }
        return Optional.empty();
    }

    private String toJsType(Class<?> type) {
        if (this.isNumber(type)) {
            return "number";
        }
        if (this.isBoolean(type)) {
            return "boolean";
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return "string";
        }
        if (Void.TYPE == type) {
            return "undefined";
        }
        return type.getSimpleName();
    }

    private boolean isBuiltIn(Class<?> clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return true;
        }
        return this.isNumber(clazz) || clazz.getPackage().getName().startsWith("java");
    }

    private boolean isNumber(Class<?> type) {
        return primitiveNumbers.contains(type) || Number.class.isAssignableFrom(type);
    }

    private boolean isBoolean(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    private boolean jsNameClash(String name) {
        return Collections.singletonList("Iterator").contains(name);
    }

    public String jsDocAnnotationFor(Class<?> aClass) {
        return "/** @type {!" + this.toJsType(aClass) + "} */";
    }
}

