/*
 * Decompiled with CFR 0.152.
 */
package de.factoryfx.javascript.data.attributes.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import de.factoryfx.javascript.data.attributes.types.ScriptExecutor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import javafx.util.Pair;

public class Javascript<A> {
    private final String code;
    @JsonIgnore
    private final String headerCode;
    @JsonIgnore
    private final String declarationCode;
    @JsonIgnore
    private final ScriptExecutorCache scriptExecutorCache = new ScriptExecutorCache();

    @JsonCreator
    public Javascript(String code) {
        this(code, "", "");
    }

    public Javascript() {
        this("", "", "");
    }

    public Javascript(String code, String headerCode, String declarationCode) {
        this.code = code;
        this.headerCode = headerCode;
        this.declarationCode = declarationCode;
    }

    public boolean match(Javascript<A> o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return Objects.equals(this.code, o.code) && Objects.equals(this.headerCode, o.headerCode);
    }

    @JsonValue
    public String getCode() {
        return this.code;
    }

    public void execute(A api) {
        ScriptExecutor scriptExecutor = this.scriptExecutorCache.take();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("api", api);
        scriptExecutor.execute(map);
        this.scriptExecutorCache.putBack(scriptExecutor);
    }

    public Javascript<?> copyWithNewCode(String newCode) {
        return new Javascript<A>(newCode, this.headerCode, this.declarationCode);
    }

    public String getHeaderCode() {
        return this.headerCode;
    }

    public String getDeclarationCode() {
        return this.declarationCode;
    }

    final class ScriptExecutorCache {
        final LinkedBlockingDeque<ScriptExecutor> executors = new LinkedBlockingDeque();

        ScriptExecutorCache() {
        }

        public ScriptExecutor take() {
            ScriptExecutor executor = this.executors.pollFirst();
            if (executor == null) {
                return this.createExecutor();
            }
            return executor;
        }

        public void putBack(ScriptExecutor scriptExecutor) {
            this.executors.push(scriptExecutor);
        }

        private ScriptExecutor createExecutor() {
            return new ScriptExecutor(Collections.singletonList(new Pair((Object)"header", (Object)Javascript.this.headerCode)), "rule", Javascript.this.code, Collections.emptyMap());
        }
    }
}

