/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.javascript.data.attributes.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.javascript.jscomp.SourceFile;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.AttributeChangeListener;
import io.github.factoryfx.factory.attribute.AttributeCopy;
import io.github.factoryfx.factory.attribute.AttributeMatch;
import io.github.factoryfx.factory.attribute.ImmutableValueAttribute;
import io.github.factoryfx.javascript.data.attributes.types.DeclareJavaInput;
import io.github.factoryfx.javascript.data.attributes.types.Externs;
import io.github.factoryfx.javascript.data.attributes.types.Javascript;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class JavascriptAttribute<A>
extends ImmutableValueAttribute<Javascript<A>, JavascriptAttribute<A>> {
    @JsonIgnore
    private final Supplier<List<? extends FactoryBase<?, ?>>> data;
    @JsonIgnore
    private final Class<A> apiClass;
    @JsonIgnore
    private final Function<List<? extends FactoryBase<?, ?>>, String> headerCreator = this::defaultCreateHeader;
    private Consumer<Runnable> runlaterExecutor = Runnable::run;
    private DirtyTrackingThread dirtyTracking;

    public JavascriptAttribute(Supplier<List<? extends FactoryBase<?, ?>>> data, Class<A> apiClass) {
        this.data = data;
        this.apiClass = apiClass;
        this.set(new Javascript("", this.createHeader(), this.createHeaderApi()));
    }

    public boolean internal_mergeMatch(AttributeMatch<Javascript<A>> value) {
        if (this.value == null && value.get() == null) {
            return true;
        }
        if (this.value == null) {
            return false;
        }
        return Objects.equals(((Javascript)this.value).getCode(), ((Javascript)value.get()).getCode());
    }

    public void internal_copyTo(AttributeCopy<Javascript<A>> copyAttribute, int level, int maxLevel, List<FactoryBase<?, ?>> oldData, FactoryBase<?, ?> parent, FactoryBase<?, ?> root) {
        if (this.get() == null) {
            copyAttribute.set(new Javascript());
        } else {
            copyAttribute.set(new Javascript(((Javascript)this.get()).getCode()));
        }
    }

    public List<SourceFile> internal_getExterns() {
        return Externs.get();
    }

    private String createHeaderApi() {
        DeclareJavaInput createDecl = new DeclareJavaInput();
        createDecl.declareVariable("api", this.apiClass);
        return createDecl.sourceScript();
    }

    private String createHeader() {
        return this.headerCreator.apply(this.data.get());
    }

    private String defaultCreateHeader(List<? extends FactoryBase<?, ?>> list) {
        StringBuilder sb = new StringBuilder();
        if (list.size() == 1) {
            sb.append("var data = ");
        } else {
            sb.append("var data = [");
        }
        int initialLen = sb.length();
        for (FactoryBase<?, ?> d : list) {
            if (d != null) {
                this.writeData(sb, d);
                sb.append(',');
                continue;
            }
            sb.append("null,");
        }
        if (sb.length() > initialLen) {
            sb.setLength(sb.length() - 1);
        }
        if (list.size() == 1) {
            sb.append(";\n");
        } else {
            sb.append("];\n");
        }
        return sb.toString();
    }

    private void writeData(StringBuilder sb, FactoryBase<?, ?> d) {
        sb.append("{");
        ObjectMapper mapper = new ObjectMapper();
        int oldLen = sb.length();
        d.internal().visitAttributesFlat((name, attribute) -> {
            try {
                Object value = attribute.get();
                sb.append("\"").append(name).append("\" : ");
                if (value instanceof FactoryBase) {
                    this.writeData(sb, (FactoryBase)value);
                } else {
                    sb.append(mapper.writeValueAsString(value));
                }
                sb.append(",");
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        if (sb.length() > oldLen) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
    }

    public Javascript<A> get() {
        Javascript currentValue = new Javascript(((Javascript)super.get()).getCode(), this.createHeader(), this.createHeaderApi());
        if (!currentValue.match((Javascript)super.get())) {
            this.set(currentValue);
        }
        return (Javascript)super.get();
    }

    public void internal_setRunlaterExecutor(Consumer<Runnable> runlaterExecutor) {
        this.runlaterExecutor = runlaterExecutor;
    }

    void runLater(Runnable runnable) {
        this.runlaterExecutor.accept(runnable);
    }

    public void internal_addListener(AttributeChangeListener<Javascript<A>, JavascriptAttribute<A>> listener) {
        super.internal_addListener(listener);
        if (this.dirtyTracking == null) {
            this.dirtyTracking = new DirtyTrackingThread();
            this.dirtyTracking.setDaemon(true);
            this.dirtyTracking.start();
        }
    }

    public void internal_removeListener(AttributeChangeListener<Javascript<A>, JavascriptAttribute<A>> listener) {
        super.internal_removeListener(listener);
        if (this.listenersEmpty() && this.dirtyTracking != null) {
            this.dirtyTracking.stopTracking();
            this.dirtyTracking = null;
        }
    }

    public void internal_endUsage() {
        if (this.dirtyTracking != null) {
            this.dirtyTracking.stopTracking();
        }
        super.internal_endUsage();
    }

    class DirtyTrackingThread
    extends Thread {
        volatile boolean tracking = true;
        Javascript<A> previousValue = JavascriptAttribute.this.get();

        DirtyTrackingThread() {
        }

        @Override
        public void run() {
            super.run();
            while (this.tracking) {
                Object currentValue = JavascriptAttribute.this.get();
                if (!((Javascript)currentValue).getHeaderCode().equals(this.previousValue.getHeaderCode())) {
                    JavascriptAttribute.this.set(currentValue);
                }
                this.previousValue = currentValue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void stopTracking() {
            this.tracking = false;
        }
    }
}

