/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.javamongodbutils;

import ch.framedev.javamongodbutils.Callback;
import ch.framedev.javamongodbutils.MongoDBManager;
import ch.framedev.simplejsonutils.JsonParser;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bson.Document;
import org.bson.conversions.Bson;

public class BackendMongoDBManager {
    private final MongoDBManager mongoDBManager;
    private final ExecutorService executor = Executors.newFixedThreadPool(10);

    public BackendMongoDBManager(MongoDBManager mongoDBManager) {
        this.mongoDBManager = mongoDBManager;
    }

    public MongoDBManager getMongoManager() {
        return this.mongoDBManager;
    }

    public void createData(String where, Object dataWhere, HashMap<String, Object> data, String collection) {
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            Document result = (Document)collections.find(new Document(where, dataWhere)).first();
            if (result == null) {
                Document dc = new Document(where, dataWhere);
                dc.putAll((Map<? extends String, ?>)data);
                collections.insertOne(dc, new InsertOneOptions().bypassDocumentValidation(false));
            }
        } else {
            this.mongoDBManager.getDatabase().createCollection(collection);
            MongoCollection<Document> collections = this.getCollection(collection);
            Document result = (Document)collections.find(new Document(where, dataWhere)).first();
            if (result == null) {
                Document dc = new Document(where, dataWhere);
                dc.putAll((Map<? extends String, ?>)data);
                collections.insertOne(dc, new InsertOneOptions().bypassDocumentValidation(false));
            }
        }
    }

    public void createDataAsync(final String where, final Object dataWhere, final HashMap<String, Object> data, final String collection, Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean resultBoolean) {
                if (resultBoolean.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document result = (Document)collections.find(new Document(where, dataWhere)).first();
                    if (result == null) {
                        Document dc = new Document(where, dataWhere);
                        dc.putAll(data);
                        collections.insertOne(dc, new InsertOneOptions().bypassDocumentValidation(false));
                    }
                } else {
                    this.this$0.mongoDBManager.getDatabase().createCollection(collection);
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document result = (Document)collections.find(new Document(where, dataWhere)).first();
                    if (result == null) {
                        Document dc = new Document(where, dataWhere);
                        dc.putAll(data);
                        collections.insertOne(dc, new InsertOneOptions().bypassDocumentValidation(false));
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public void createData(String where, Object dataWhere, Object object, String collection) {
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            Document result = (Document)collections.find(new Document(where, dataWhere)).first();
            if (result == null) {
                Document document = Document.parse(new JsonParser().serializeObject(object));
                collections.insertOne(document, new InsertOneOptions().bypassDocumentValidation(false));
            }
        } else {
            this.mongoDBManager.getDatabase().createCollection(collection);
            MongoCollection<Document> collections = this.getCollection(collection);
            Document result = (Document)collections.find(new Document(where, dataWhere)).first();
            if (result == null) {
                Document document = Document.parse(new JsonParser().serializeObject(object));
                collections.insertOne(document, new InsertOneOptions().bypassDocumentValidation(false));
            }
        }
    }

    public void createDataAsync(final String where, final Object dataWhere, final Object object, final String collection, Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document result = (Document)collections.find(new Document(where, dataWhere)).first();
                    if (result == null) {
                        Document document = Document.parse(new JsonParser().serializeObject(object));
                        collections.insertOne(document, new InsertOneOptions().bypassDocumentValidation(false));
                    }
                } else {
                    this.this$0.mongoDBManager.getDatabase().createCollection(collection);
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document result = (Document)collections.find(new Document(where, dataWhere)).first();
                    if (result == null) {
                        Document document = Document.parse(new JsonParser().serializeObject(object));
                        collections.insertOne(document, new InsertOneOptions().bypassDocumentValidation(false));
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public void createData(String where, Object dataWhere, String jsonText, String collection) {
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            Document result = (Document)collections.find(new Document(where, dataWhere)).first();
            if (result == null) {
                Document document = Document.parse(jsonText);
                collections.insertOne(document, new InsertOneOptions().bypassDocumentValidation(false));
            }
        } else {
            this.mongoDBManager.getDatabase().createCollection(collection);
            MongoCollection<Document> collections = this.getCollection(collection);
            Document result = (Document)collections.find(new Document(where, dataWhere)).first();
            if (result == null) {
                Document document = Document.parse(jsonText);
                collections.insertOne(document, new InsertOneOptions().bypassDocumentValidation(false));
            }
        }
    }

    public void createDataAsync(final String where, final Object dataWhere, final String jsonText, final String collection, Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean aBoolean) {
                if (aBoolean.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document result = (Document)collections.find(new Document(where, dataWhere)).first();
                    if (result == null) {
                        Document document = Document.parse(jsonText);
                        collections.insertOne(document, new InsertOneOptions().bypassDocumentValidation(false));
                    }
                } else {
                    this.this$0.mongoDBManager.getDatabase().createCollection(collection);
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document result = (Document)collections.find(new Document(where, dataWhere)).first();
                    if (result == null) {
                        Document document = Document.parse(jsonText);
                        collections.insertOne(document, new InsertOneOptions().bypassDocumentValidation(false));
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public Object getObject(String where, Object data, String selected, String collection) {
        MongoCollection<Document> collections;
        Document document;
        if (this.existsCollection(collection) && (document = (Document)(collections = this.getCollection(collection)).find(new Document(where, data)).first()) != null) {
            return document.get(selected);
        }
        return null;
    }

    public void getObjectAsync(final String where, final Object data, final String selected, final String collection, final Callback<Object> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document document = (Document)collections.find(new Document(where, data)).first();
                    if (document != null) {
                        callback.onResult(document.get(selected));
                    } else {
                        callback.onResult(null);
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public <T> T getObject(String where, Object data, String selected, String collection, Class<T> type) {
        MongoCollection<Document> collections;
        Document document;
        if (this.existsCollection(collection) && (document = (Document)(collections = this.getCollection(collection)).find(new Document(where, data)).first()) != null) {
            return (T)document.get((Object)selected, type);
        }
        return null;
    }

    public <T> void getObjectAsync(final String where, final Object data, final String selected, final String collection, final Class<T> type, final Callback<T> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document document = (Document)collections.find(new Document(where, data)).first();
                    if (document != null) {
                        callback.onResult(document.get((Object)selected, type));
                    } else {
                        callback.onResult(null);
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public Document getDocument(String where, Object data, String collection) {
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            return (Document)collections.find(new Document(where, data)).first();
        }
        return null;
    }

    public void getDocumentAsync(final String where, final Object data, final String collection, final Callback<Document> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    callback.onResult((Document)collections.find(new Document(where, data)).first());
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public Document getDocument(String where, Object data, String andData, Object andValue, String collection) {
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            Document filter = new Document(where, data);
            filter.append(andData, andValue);
            return (Document)collections.find(filter).first();
        }
        return null;
    }

    public void getDocumentAsync(final String where, final Object data, final String andData, final Object andValue, final String collection, final Callback<Document> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document filter = new Document(where, data);
                    filter.append(andData, andValue);
                    callback.onResult((Document)collections.find(filter).first());
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public void updateData(String where, Object data, String selected, Object dataSelected, String collection) {
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            Document document = (Document)collections.find(new Document(where, data)).first();
            if (document != null) {
                Document document1 = new Document(selected, dataSelected);
                Document document2 = new Document("$set", document1);
                if (document.get(where) != null) {
                    collections.updateOne((Bson)document, document2);
                } else {
                    document.put(selected, dataSelected);
                    collections.updateOne((Bson)Objects.requireNonNull((Document)collections.find(new Document(where, data)).first()), document);
                }
            }
        } else {
            this.mongoDBManager.getDatabase().createCollection(collection);
            MongoCollection<Document> collections = this.getCollection(collection);
            Document document = (Document)collections.find(new Document(where, data)).first();
            if (document != null) {
                Document filter = new Document(selected, dataSelected);
                Document query = new Document("$set", filter);
                collections.updateOne((Bson)document, query);
            }
        }
    }

    public void updateDataAsync(final String where, final Object data, final String selected, final Object dataSelected, final String collection, Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document document = (Document)collections.find(new Document(where, data)).first();
                    if (document != null) {
                        Document document1 = new Document(selected, dataSelected);
                        Document document2 = new Document("$set", document1);
                        if (document.get(where) != null) {
                            collections.updateOne((Bson)document, document2);
                        } else {
                            document.put(selected, dataSelected);
                            collections.updateOne((Bson)Objects.requireNonNull((Document)collections.find(new Document(where, data)).first()), document);
                        }
                    }
                } else {
                    this.this$0.mongoDBManager.getDatabase().createCollection(collection);
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document document = (Document)collections.find(new Document(where, data)).first();
                    if (document != null) {
                        Document filter = new Document(selected, dataSelected);
                        Document query = new Document("$set", filter);
                        collections.updateOne((Bson)document, query);
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public void updateAll(String where, Object whereData, HashMap<String, Object> newData, String collection) {
        MongoCollection<Document> collections;
        Document document;
        if (this.existsCollection(collection) && (document = (Document)(collections = this.getCollection(collection)).find(new Document(where, whereData)).first()) != null && document.get(where) != null) {
            Document doc = Document.parse(new JsonParser().serializeObject(newData));
            collections.replaceOne(document, doc);
        }
    }

    public void updateAllAsync(final String where, final Object whereData, final HashMap<String, Object> newData, final String collection, final Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                MongoCollection<Document> collections;
                Document document;
                if (result.booleanValue() && (document = (Document)(collections = this.this$0.getCollection(collection)).find(new Document(where, whereData)).first()) != null && document.get(where) != null) {
                    Document doc = Document.parse(new JsonParser().serializeObject(newData));
                    collections.replaceOne(document, doc);
                    callback.onResult(null);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public void updateAll(String where, Object whereData, Object object, String collection) {
        MongoCollection<Document> collections;
        Document document;
        if (this.existsCollection(collection) && (document = (Document)(collections = this.getCollection(collection)).find(new Document(where, whereData)).first()) != null && document.get(where) != null) {
            Document doc = Document.parse(new JsonParser().serializeObject(object));
            collections.replaceOne(document, doc);
        }
    }

    public void updateAllAsync(final String where, final Object whereData, final Object object, final String collection, final Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                MongoCollection<Document> collections;
                Document document;
                if (result.booleanValue() && (document = (Document)(collections = this.this$0.getCollection(collection)).find(new Document(where, whereData)).first()) != null && document.get(where) != null) {
                    Document doc = Document.parse(new JsonParser().serializeObject(object));
                    collections.replaceOne(document, doc);
                    callback.onResult(null);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public void updateAll(String where, Object whereData, String jsonText, String collection) {
        MongoCollection<Document> collections;
        Document document;
        if (this.existsCollection(collection) && (document = (Document)(collections = this.getCollection(collection)).find(new Document(where, whereData)).first()) != null && document.get(where) != null) {
            Document doc = Document.parse(jsonText);
            collections.replaceOne(document, doc);
        }
    }

    public void updateAllAsync(final String where, final Object whereData, final String jsonText, final String collection, final Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                MongoCollection<Document> collections;
                Document document;
                if (result.booleanValue() && (document = (Document)(collections = this.this$0.getCollection(collection)).find(new Document(where, whereData)).first()) != null && document.get(where) != null) {
                    Document doc = Document.parse(jsonText);
                    collections.replaceOne(document, doc);
                    callback.onResult(null);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public boolean exists(String where, Object data, String whereSelected, String collection) {
        MongoCollection<Document> collections;
        Document document;
        if (this.existsCollection(collection) && (document = (Document)(collections = this.getCollection(collection)).find(new Document(where, data)).first()) != null) {
            return document.get(whereSelected) != null;
        }
        return false;
    }

    public void existsAsync(final String where, final Object data, final String whereSelected, final String collection, final Callback<Boolean> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document document = (Document)collections.find(new Document(where, data)).first();
                    if (document != null) {
                        callback.onResult(document.get(whereSelected) != null);
                    } else {
                        callback.onResult(false);
                    }
                } else {
                    callback.onResult(false);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public boolean exists(String where, Object data, String collection) {
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            Document document = (Document)collections.find(new Document(where, data)).first();
            return document != null;
        }
        return false;
    }

    public void existsAsync(final String where, final Object data, final String collection, final Callback<Boolean> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document document = (Document)collections.find(new Document(where, data)).first();
                    callback.onResult(document != null);
                } else {
                    callback.onResult(false);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public boolean exists(String where, Object data, String whereSelected, Object whereData, String collection) {
        MongoCollection<Document> collections;
        Document document;
        if (this.existsCollection(collection) && (document = (Document)(collections = this.getCollection(collection)).find(new Document(where, data)).first()) != null) {
            return document.get(whereSelected) == whereData;
        }
        return false;
    }

    public void existsAsync(final String where, final Object data, final String whereSelected, final Object whereData, final String collection, final Callback<Boolean> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document document = (Document)collections.find(new Document(where, data)).first();
                    if (document != null) {
                        callback.onResult(document.get(whereSelected) == whereData);
                    } else {
                        callback.onResult(false);
                    }
                } else {
                    callback.onResult(false);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public void insertData(String where, Object data, String newKey, Object newValue, String collection) {
        MongoCollection<Document> collections;
        Document document;
        if (this.existsCollection(collection) && (document = (Document)(collections = this.getCollection(collection)).find(new Document(where, data)).first()) != null) {
            collections.updateOne((Bson)new Document(where, data), new Document("$set", new Document(newKey, newValue)));
        }
    }

    public void insertDataAsync(final String where, final Object data, final String newKey, final Object newValue, final String collection, final Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                MongoCollection<Document> collections;
                Document document;
                if (result.booleanValue() && (document = (Document)(collections = this.this$0.getCollection(collection)).find(new Document(where, data)).first()) != null) {
                    collections.updateOne((Bson)new Document(where, data), new Document("$set", new Document(newKey, newValue)));
                    callback.onResult(null);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public void insertManyData(String where, Object data, List<String> newKeys, List<Object> newValues, String collection) {
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            Document filter = new Document(where, data);
            Document updateDocument = new Document();
            for (int i = 0; i < newKeys.size(); ++i) {
                String newKey = newKeys.get(i);
                Object newValue = newValues.get(i);
                updateDocument.append(newKey, newValue);
            }
            UpdateResult result = collections.updateOne((Bson)filter, new Document("$set", updateDocument));
            if (result.getModifiedCount() > 0L) {
                System.out.println("Document updated successfully");
            } else {
                System.out.println("Document not found or no modifications made");
            }
        }
    }

    public void insertManyDataAsync(final String where, final Object data, final List<String> newKeys, final List<Object> newValues, final String collection, final Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document filter = new Document(where, data);
                    Document updateDocument = new Document();
                    for (int i = 0; i < newKeys.size(); ++i) {
                        String newKey = (String)newKeys.get(i);
                        Object newValue = newValues.get(i);
                        updateDocument.append(newKey, newValue);
                    }
                    UpdateResult resultUpdate = collections.updateOne((Bson)filter, new Document("$set", updateDocument));
                    if (resultUpdate.getModifiedCount() > 0L) {
                        System.out.println("Document updated successfully");
                    } else {
                        System.out.println("Document not found or no modifications made");
                    }
                    callback.onResult(null);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public boolean existsCollection(String collection) {
        MongoCollection<Document> collections = this.getCollection(collection);
        return collections != null;
    }

    public void existsCollectionAsync(String collection, Callback<Boolean> callback) {
        this.executor.execute(() -> {
            MongoCollection<Document> collections = this.getCollection(collection);
            callback.onResult(collections != null);
        });
    }

    public List<Object> getList(String where, Object data, String selected, String collection) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            collections.find(new Document(where, data)).forEach(document -> {
                if (document != null) {
                    list.add(document.get(selected));
                }
            });
            return list;
        }
        return null;
    }

    public void getListAsync(final String where, final Object data, final String selected, final String collection, final Callback<List<Object>> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    ArrayList list = new ArrayList();
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    collections.find(new Document(where, data)).forEach(document -> {
                        if (document != null) {
                            list.add(document.get(selected));
                        }
                    });
                    callback.onResult(list);
                } else {
                    callback.onResult(null);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public List<Document> getAllDocuments(String collection) {
        ArrayList<Document> list = new ArrayList<Document>();
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            FindIterable<Document> find = collections.find();
            for (Document document : find) {
                list.add(document);
            }
        }
        return list;
    }

    public void getAllDocumentsAsync(final String collection, final Callback<List<Document>> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    ArrayList<Document> list = new ArrayList<Document>();
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    FindIterable<Document> find = collections.find();
                    for (Document document : find) {
                        list.add(document);
                    }
                    callback.onResult(list);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public List<Document> getAllDocuments(String whereData, Object whereValue, String collection) {
        ArrayList<Document> list = new ArrayList<Document>();
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            FindIterable<Document> find = collections.find(new Document(whereData, whereValue));
            for (Document document : find) {
                list.add(document);
            }
        }
        return list;
    }

    public void getAllDocumentsAsync(final String whereData, final Object whereValue, final String collection, final Callback<List<Document>> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    ArrayList<Document> list = new ArrayList<Document>();
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    FindIterable<Document> find = collections.find(new Document(whereData, whereValue));
                    for (Document document : find) {
                        list.add(document);
                    }
                    callback.onResult(list);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public <T> List<T> getAllObjects(String collection, Class<T> type) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            FindIterable<Document> find = collections.find();
            for (Document document : find) {
                list.add(new JsonParser().deserializeObject(document.toJson(), type));
            }
        }
        return list;
    }

    public <T> void getAllObjectsAsync(final String collection, final Class<T> type, final Callback<List<T>> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    FindIterable<Document> find = collections.find();
                    for (Document document : find) {
                        list.add(new JsonParser().deserializeObject(document.toJson(), type));
                    }
                    callback.onResult(list);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public List<String> getAllCollections() {
        ArrayList<String> collectionNames = new ArrayList<String>();
        this.mongoDBManager.getDatabase().listCollectionNames().forEach(collectionNames::add);
        return collectionNames;
    }

    public void getAllCollectionsAsync(Callback<List<String>> callback) {
        this.executor.execute(() -> {
            ArrayList collectionNames = new ArrayList();
            this.mongoDBManager.getDatabase().listCollectionNames().forEach(collectionNames::add);
            callback.onResult(collectionNames);
        });
    }

    public <T> T getObjectFromJson(String where, Object whereData, String collection, Class<T> class__) {
        MongoCollection<Document> collections;
        Document document;
        Object t = null;
        if (this.existsCollection(collection) && (document = (Document)(collections = this.getCollection(collection)).find(new Document(where, whereData)).first()) != null) {
            String json = document.toJson();
            t = new JsonParser().deserializeObject(json, class__);
        }
        return (T)t;
    }

    public <T> void getObjectFromJsonAsync(final String where, final Object whereData, final String collection, final Class<T> class__, final Callback<T> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                MongoCollection<Document> collections;
                Document document;
                Object t = null;
                if (result.booleanValue() && (document = (Document)(collections = this.this$0.getCollection(collection)).find(new Document(where, whereData)).first()) != null) {
                    String json = document.toJson();
                    t = new JsonParser().deserializeObject(json, class__);
                }
                callback.onResult(t);
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public void removeDocument(String where, Object whereData, String collection) {
        MongoCollection<Document> collections;
        Document document;
        if (this.existsCollection(collection) && (document = (Document)(collections = this.getCollection(collection)).find(new Document(where, whereData)).first()) != null) {
            collections.deleteMany(document);
        }
    }

    public MongoDBManager getMongoDBManager() {
        return this.mongoDBManager;
    }

    public void removeDocumentAsync(final String where, final Object whereData, final String collection, final Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document document = (Document)collections.find(new Document(where, whereData)).first();
                    if (document != null) {
                        collections.deleteMany(document);
                    }
                    callback.onResult(null);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public void removeDocument(String where, Object whereData, String andData, Object andValue, String collection) {
        if (this.existsCollection(collection)) {
            MongoCollection<Document> collections = this.getCollection(collection);
            Document filter = new Document(where, whereData);
            filter.append(andData, andValue);
            Document document = (Document)collections.find(filter).first();
            if (document != null) {
                collections.deleteMany(document);
            }
        }
    }

    public void removeDocumentAsync(final String where, final Object whereData, final String andData, final Object andValue, final String collection, final Callback<Void> callback) {
        this.executor.execute(() -> this.existsCollectionAsync(collection, new Callback<Boolean>(){
            final /* synthetic */ BackendMongoDBManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    MongoCollection<Document> collections = this.this$0.getCollection(collection);
                    Document filter = new Document(where, whereData);
                    filter.append(andData, andValue);
                    Document document = (Document)collections.find(filter).first();
                    if (document != null) {
                        collections.deleteMany(document);
                    }
                    callback.onResult(null);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                throwable.printStackTrace();
            }
        }));
    }

    public MongoCollection<Document> getCollection(String collectionName) {
        return this.mongoDBManager.getDatabase().getCollection(collectionName);
    }
}

