/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejsonutils;

import ch.framedev.simplejsonutils.Flag;
import ch.framedev.simplejsonutils.SimpleJsonParser;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class JsonConfiguration {
    private final File file;
    private Map<String, Object> data;

    public JsonConfiguration(File file) {
        this.file = file;
    }

    public JsonConfiguration(File source, File file) {
        this.file = file;
        this.loadDefaults(source);
    }

    private void loadDefaults(File source) {
        if (source.exists()) {
            SimpleJsonParser simpleJsonParser = new SimpleJsonParser(Flag.PRETTY_PRINT);
            try {
                if (!this.file.exists()) {
                    this.data = simpleJsonParser.loadFromFileToMap(source);
                    this.save();
                }
                Map<String, Object> defaults = simpleJsonParser.loadFromFileToMap(source);
                this.data = simpleJsonParser.loadFromFileToMap(this.file);
                for (Map.Entry<String, Object> entry : defaults.entrySet()) {
                    Object defaultValue = entry.getValue();
                    Object existingValue = this.data.get(entry.getKey());
                    if (defaultValue instanceof Map && existingValue instanceof Map) {
                        this.mergeMaps((Map)existingValue, (Map)defaultValue);
                        continue;
                    }
                    this.data.putIfAbsent(entry.getKey(), defaultValue);
                }
                this.save();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.data = new HashMap<String, Object>();
        }
    }

    private void mergeMaps(Map<String, Object> target, Map<String, Object> defaults) {
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            Object defaultValue = entry.getValue();
            Object existingValue = target.get(entry.getKey());
            if (defaultValue instanceof Map && existingValue instanceof Map) {
                this.mergeMaps((Map)existingValue, (Map)defaultValue);
                continue;
            }
            target.putIfAbsent(entry.getKey(), defaultValue);
        }
    }

    public void load() {
        SimpleJsonParser simpleJsonParser = new SimpleJsonParser(Flag.PRETTY_PRINT);
        if (this.file.exists()) {
            try {
                this.data = simpleJsonParser.loadFromFileToMap(this.file);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.data = new HashMap<String, Object>();
        }
    }

    public void save() {
        SimpleJsonParser simpleJsonParser = new SimpleJsonParser(Flag.PRETTY_PRINT);
        try {
            simpleJsonParser.saveToFile(this.file, this.data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object get(String key) {
        return this.data != null ? this.data.get(key) : null;
    }

    public String getString(String key) {
        Object value = this.get(key);
        return value != null ? value.toString() : null;
    }

    public Integer getInt(String key) {
        Object value = this.get(key);
        return value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : null;
    }

    public Double getDouble(String key) {
        Object value = this.get(key);
        return value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : null;
    }

    public Boolean getBoolean(String key) {
        Object value = this.get(key);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    public Long getLong(String key) {
        Object value = this.get(key);
        return value instanceof Number ? Long.valueOf(((Number)value).longValue()) : null;
    }

    public Float getFloat(String key) {
        Object value = this.get(key);
        return value instanceof Number ? Float.valueOf(((Number)value).floatValue()) : null;
    }

    public void set(String key, Object value) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, value);
    }

    public boolean exists(String key) {
        return this.data != null && this.data.containsKey(key);
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

