/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.authentication;

import com.mongodb.MongoClientException;
import com.mongodb.internal.ExpirableValue;
import com.mongodb.internal.Locks;
import com.mongodb.internal.authentication.CredentialInfo;
import com.mongodb.internal.authentication.HttpHelper;
import com.mongodb.lang.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Duration;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.json.JsonParseException;

public final class AzureCredentialHelper {
    private static final String ACCESS_TOKEN_FIELD = "access_token";
    private static final String EXPIRES_IN_FIELD = "expires_in";
    private static final Lock CACHED_ACCESS_TOKEN_LOCK = new ReentrantLock();
    private static volatile ExpirableValue<String> cachedAccessToken = ExpirableValue.expired();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BsonDocument obtainFromEnvironment() {
        String accessToken;
        Optional<String> cachedValue = cachedAccessToken.getValue();
        if (cachedValue.isPresent()) {
            accessToken = cachedValue.get();
        } else {
            Locks.lockInterruptibly(CACHED_ACCESS_TOKEN_LOCK);
            try {
                cachedValue = cachedAccessToken.getValue();
                if (cachedValue.isPresent()) {
                    accessToken = cachedValue.get();
                } else {
                    long startNanoTime = System.nanoTime();
                    CredentialInfo response = AzureCredentialHelper.fetchAzureCredentialInfo("https://vault.azure.net", null);
                    accessToken = response.getAccessToken();
                    Duration duration = response.getExpiresIn().minus(Duration.ofMinutes(1L));
                    cachedAccessToken = ExpirableValue.expirable(accessToken, duration, startNanoTime);
                }
            }
            finally {
                CACHED_ACCESS_TOKEN_LOCK.unlock();
            }
        }
        return new BsonDocument("accessToken", new BsonString(accessToken));
    }

    public static CredentialInfo fetchAzureCredentialInfo(String resource, @Nullable String clientId) {
        BsonDocument responseDocument;
        String endpoint = "http://169.254.169.254:80/metadata/identity/oauth2/token?api-version=2018-02-01&resource=" + AzureCredentialHelper.getEncoded(resource) + (clientId == null ? "" : "&client_id=" + AzureCredentialHelper.getEncoded(clientId));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Metadata", "true");
        headers.put("Accept", "application/json");
        try {
            responseDocument = BsonDocument.parse(HttpHelper.getHttpContents("GET", endpoint, headers));
        }
        catch (JsonParseException e) {
            throw new MongoClientException("Exception parsing JSON from Azure IMDS metadata response.", e);
        }
        if (!responseDocument.isString(ACCESS_TOKEN_FIELD)) {
            throw new MongoClientException(String.format("The %s field from Azure IMDS metadata response is missing or is not a string", ACCESS_TOKEN_FIELD));
        }
        if (!responseDocument.isString(EXPIRES_IN_FIELD)) {
            throw new MongoClientException(String.format("The %s field from Azure IMDS metadata response is missing or is not a string", EXPIRES_IN_FIELD));
        }
        String accessToken = responseDocument.getString(ACCESS_TOKEN_FIELD).getValue();
        int expiresInSeconds = Integer.parseInt(responseDocument.getString(EXPIRES_IN_FIELD).getValue());
        return new CredentialInfo(accessToken, Duration.ofSeconds(expiresInSeconds));
    }

    static String getEncoded(String resource) {
        try {
            return URLEncoder.encode(resource, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private AzureCredentialHelper() {
    }
}

