/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

public enum Time {
    MILLISECONDS(0.001),
    SECONDS(1.0),
    MINUTES(60.0),
    HOURS(3600.0),
    DAYS(86400.0),
    WEEKS(604800.0),
    MONTHS(2628000.0),
    YEARS(3.1536E7);

    private final double secondsPerUnit;

    private Time(double secondsPerUnit) {
        this.secondsPerUnit = secondsPerUnit;
    }

    public double getSecondsPerUnit() {
        return this.secondsPerUnit;
    }

    public static double convert(double value, Time from, Time to) {
        return value * from.secondsPerUnit / to.secondsPerUnit;
    }

    public static double convert(long value, Time from, Time to) {
        return Time.convert((double)value, from, to);
    }

    public double convertTo(double value, Time to) {
        return Time.convert(value, this, to);
    }

    public double convertTo(long value, Time to) {
        return Time.convert((double)value, this, to);
    }

    public double toMilliseconds(double value) {
        return this.convertTo(value, MILLISECONDS);
    }

    public double toMilliseconds(long value) {
        return this.toMilliseconds((double)value);
    }

    public double toSeconds(double value) {
        return this.convertTo(value, SECONDS);
    }

    public double toSeconds(long value) {
        return this.toSeconds((double)value);
    }

    public double toMinutes(double value) {
        return this.convertTo(value, MINUTES);
    }

    public double toMinutes(long value) {
        return this.toMinutes((double)value);
    }

    public double toHours(double value) {
        return this.convertTo(value, HOURS);
    }

    public double toHours(long value) {
        return this.toHours((double)value);
    }

    public double toDays(double value) {
        return this.convertTo(value, DAYS);
    }

    public double toDays(long value) {
        return this.toDays((double)value);
    }

    public double toWeeks(double value) {
        return this.convertTo(value, WEEKS);
    }

    public double toWeeks(long value) {
        return this.toWeeks((double)value);
    }

    public double toMonths(double value) {
        return this.convertTo(value, MONTHS);
    }

    public double toMonths(long value) {
        return this.toMonths((double)value);
    }

    public double toYears(double value) {
        return this.convertTo(value, YEARS);
    }

    public double toYears(long value) {
        return this.toYears((double)value);
    }

    public String toString() {
        return this.name() + " (" + this.secondsPerUnit + " seconds)";
    }
}

