/*
 * Decompiled with CFR 0.152.
 */
package io.github.freddielindsey;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javafx.util.Pair;

public final class CommandRunner {
    public static Process run(List<String> args) throws IOException, InterruptedException {
        return CommandRunner.run(args, FileSystems.getDefault().getPath(".", new String[0]));
    }

    public static Process run(List<String> args, Path workingDir) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(args);
        processBuilder.directory(workingDir.toFile());
        return processBuilder.start();
    }

    public static Pair<List<String>, List<String>> runAndFinish(List<String> args) throws IOException, InterruptedException {
        return CommandRunner.runAndFinish(args, FileSystems.getDefault().getPath(".", new String[0]));
    }

    public static Pair<List<String>, List<String>> runAndFinish(List<String> args, Path workingDir) throws IOException, InterruptedException {
        Process process = CommandRunner.run(args, workingDir);
        process.waitFor();
        return new Pair(CommandRunner.getStreamContent(process.getInputStream()), CommandRunner.getStreamContent(process.getErrorStream()));
    }

    private static List<String> getStreamContent(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream);
        ArrayList<String> result = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            result.add(scanner.nextLine());
        }
        return result;
    }
}

