/*
 * Decompiled with CFR 0.152.
 */
package io.github.freddielindsey;

import io.github.freddielindsey.CommandRunner;
import io.github.freddielindsey.Feature;
import io.github.freddielindsey.Key;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExifTool {
    private static Double INSTALLED_VERSION;
    private final Set<Feature> features;
    private final Logger logger;
    private Process longRunningProcess;

    private ExifTool(Set<Feature> features, Logger logger) throws IOException, InterruptedException {
        this.features = features;
        this.logger = logger != null ? logger : LoggerFactory.getLogger(ExifTool.class);
        Double installedVersion = this.getInstalledVersion();
        features.forEach(feature -> {
            if (!Feature.isCompatible(feature, installedVersion)) {
                throw new UnsupportedOperationException(String.format("Feature %s not supported by ExifTool version %s", feature, installedVersion));
            }
        });
    }

    public void startLongRunningProcess() throws IOException, InterruptedException {
        if (this.features.contains((Object)Feature.STAY_OPEN)) {
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add("exiftool");
            argsList.add(Feature.getFlag(Feature.STAY_OPEN));
            argsList.add("True");
            argsList.add("-@");
            argsList.add("-");
            this.longRunningProcess = CommandRunner.run(argsList);
        }
    }

    public void cancelLongRunningProcess() throws InterruptedException {
        this.longRunningProcess.destroyForcibly().waitFor();
        assert (!this.longRunningProcess.isAlive()) : "Long running process is still alive.";
    }

    public Double getInstalledVersion() throws IOException, InterruptedException {
        if (INSTALLED_VERSION == null) {
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add("exiftool");
            argsList.add("-ver");
            this.logger.debug("Running command with args: {}", argsList);
            Pair<List<String>, List<String>> result = CommandRunner.runAndFinish(argsList);
            if (((List)result.getKey()).size() == 0) {
                throw new RuntimeException("Could not get installed version of ExifTool. Is ExifTool installed?");
            }
            this.logger.info("Installed ExifTool Version: {}", result.getKey());
            INSTALLED_VERSION = Double.parseDouble((String)((List)result.getKey()).get(0));
        }
        return INSTALLED_VERSION;
    }

    public <T> Map<Key, T> query(File file, Set<Key> keys) throws IOException, InterruptedException {
        return this.longRunningProcess != null && this.longRunningProcess.isAlive() ? this.queryLongRunning(file, keys) : this.queryShortLived(file, keys);
    }

    private <T> Map<Key, T> queryLongRunning(File file, Set<Key> keys) throws IOException, InterruptedException {
        String line;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.longRunningProcess.getOutputStream());
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-S");
        for (Key key : keys) {
            argsList.add(String.format("-%s", Key.getName(key)));
        }
        argsList.add(file.getAbsolutePath());
        argsList.add("-execute\n");
        outputStreamWriter.write(String.join((CharSequence)"\n", argsList));
        outputStreamWriter.flush();
        BufferedReader stdOutStreamReader = new BufferedReader(new InputStreamReader(this.longRunningProcess.getInputStream()));
        ArrayList<String> stdOut = new ArrayList<String>();
        while ((line = stdOutStreamReader.readLine()) != null && !line.equals("{ready}")) {
            stdOut.add(line);
        }
        BufferedReader stdErrStreamReader = new BufferedReader(new InputStreamReader(this.longRunningProcess.getErrorStream()));
        ArrayList<String> stdErr = new ArrayList<String>();
        while (stdErrStreamReader.ready() && (line = stdErrStreamReader.readLine()) != null) {
            stdErr.add(line);
        }
        return this.processQueryResult(stdOut, stdErr);
    }

    private <T> Map<Key, T> queryShortLived(File file, Set<Key> keys) throws IOException, InterruptedException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("exiftool");
        argsList.add("-S");
        for (Key key : keys) {
            argsList.add(String.format("-%s", Key.getName(key)));
        }
        argsList.add(file.getAbsolutePath());
        Pair<List<String>, List<String>> result = CommandRunner.runAndFinish(argsList);
        List stdOut = (List)result.getKey();
        List stdErr = (List)result.getValue();
        return this.processQueryResult(stdOut, stdErr);
    }

    private <T> Map<Key, T> processQueryResult(List<String> stdOut, List<String> stdErr) {
        HashMap queryResult = new HashMap();
        if (stdErr.size() > 0) {
            throw new RuntimeException(String.join((CharSequence)"\n", stdErr));
        }
        for (String line : stdOut) {
            List<String> lineSeparated = Arrays.asList(line.split(":"));
            if (lineSeparated.size() < 2) continue;
            String name = lineSeparated.get(0).trim();
            String value = String.join((CharSequence)":", lineSeparated.subList(1, lineSeparated.size())).trim();
            Optional<Key> maybeKey = Key.findKeyWithName(name);
            maybeKey.ifPresent(key -> queryResult.put(key, Key.parse(key, value)));
        }
        return queryResult;
    }

    public static class Builder {
        private Logger logger;
        private Set<Feature> features = new HashSet<Feature>();

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder features(Set<Feature> features) {
            this.features = features;
            return this;
        }

        public ExifTool build() throws IOException, InterruptedException {
            return new ExifTool(this.features, this.logger);
        }
    }
}

