/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.exception;

import io.github.giovannilamarmora.utils.exception.ExceptionCode;
import io.github.giovannilamarmora.utils.exception.GenericException;
import io.github.giovannilamarmora.utils.exception.dto.ErrorInfo;
import io.github.giovannilamarmora.utils.exception.dto.ExceptionResponse;
import io.github.giovannilamarmora.utils.interceptors.correlationID.CorrelationIdUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class UtilsException
extends Exception {
    private ExceptionCode exceptionCode;
    public final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public UtilsException() {
    }

    public UtilsException(ExceptionCode exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public UtilsException(ExceptionCode exceptionCode, String message) {
        super(message);
        this.exceptionCode = exceptionCode;
    }

    @ExceptionHandler(value={UtilsException.class})
    private ResponseEntity<ExceptionResponse> handleUtilsException(UtilsException e, HttpServletRequest request) {
        ExceptionResponse error = this.defaultResponse();
        this.LOG.error("An error happened while calling {} Downstream API: {}", (Object)request.getRequestURI(), (Object)e.getMessage());
        if (e.exceptionCode != null) {
            ErrorInfo errorMes = new ErrorInfo();
            errorMes.setExceptionCode(!e.exceptionCode.name().isBlank() ? e.exceptionCode.name() : GenericException.ERRDEFUTL001.name());
            errorMes.setStatus(e.exceptionCode.getStatus() != null ? e.exceptionCode.getStatus() : GenericException.ERRDEFUTL001.getStatus());
            error.setUrl(request.getRequestURI().isBlank() ? null : request.getRequestURI());
            if (e.exceptionCode.getMessage() != null && e.getMessage() != null && !e.exceptionCode.getMessage().isBlank() && !e.getMessage().isBlank()) {
                errorMes.setMessage("Message: " + e.exceptionCode.getMessage() + " | Exception Message: " + e.getMessage());
            } else if (e.exceptionCode.getMessage() != null && !e.exceptionCode.getMessage().isBlank() && e.getMessage() == null || e.getMessage().isBlank()) {
                errorMes.setMessage(e.exceptionCode.getMessage());
            } else {
                errorMes.setMessage(e.getMessage());
            }
            errorMes.setExceptionName(e.exceptionCode.exceptionName().isBlank() ? null : e.exceptionCode.exceptionName());
            error.setCorrelationId(CorrelationIdUtils.getCorrelationId());
            error.setError(errorMes);
            return new ResponseEntity((Object)error, e.exceptionCode.getStatus());
        }
        return new ResponseEntity((Object)error, GenericException.ERRDEFUTL001.getStatus());
    }

    @ExceptionHandler(value={Exception.class})
    private ResponseEntity<ExceptionResponse> handleException(Exception e, HttpServletRequest request) {
        ExceptionResponse error = this.defaultResponse();
        this.LOG.error("An error happened while calling {} Downstream API: {}", (Object)request.getRequestURI(), (Object)e.getMessage());
        if (e != null) {
            HttpStatus status = HttpStatus.BAD_REQUEST;
            error = UtilsException.getExceptionResponse(e, request, GenericException.ERRDEFUTL001, status);
            return new ResponseEntity((Object)error, status);
        }
        return new ResponseEntity((Object)error, GenericException.ERRDEFUTL001.getStatus());
    }

    public static ExceptionResponse getExceptionResponse(Exception e, HttpServletRequest request, ExceptionCode exceptionCode, HttpStatus status) {
        ExceptionResponse exceptionResponse = new ExceptionResponse();
        ErrorInfo errorMes = new ErrorInfo();
        HttpStatus defaultStatus = HttpStatus.BAD_REQUEST;
        errorMes.setExceptionName(e.getClass().getName().isBlank() ? null : e.getClass().getSimpleName());
        errorMes.setExceptionCode(exceptionCode != null && exceptionCode.name() != null && !exceptionCode.name().isBlank() ? exceptionCode.name() : GenericException.ERRDEFUTL001.name());
        errorMes.setStatus(status != null ? status : defaultStatus);
        if (e.getMessage() != null && !e.getMessage().isBlank()) {
            errorMes.setMessage("Exception Message: " + e.getMessage());
        } else {
            errorMes.setMessage(null);
        }
        exceptionResponse.setUrl(request.getRequestURI() == null || request.getRequestURI().isBlank() ? null : request.getRequestURI());
        exceptionResponse.setCorrelationId(CorrelationIdUtils.getCorrelationId());
        exceptionResponse.setError(errorMes);
        return exceptionResponse;
    }

    private ExceptionResponse defaultResponse() {
        ExceptionResponse exceptionResponse = new ExceptionResponse();
        ErrorInfo errorMes = new ErrorInfo();
        errorMes.setExceptionCode(GenericException.ERRDEFUTL001.name());
        errorMes.setStatus(GenericException.ERRDEFUTL001.getStatus());
        exceptionResponse.setCorrelationId(CorrelationIdUtils.getCorrelationId());
        errorMes.setMessage(GenericException.ERRDEFUTL001.getMessage());
        errorMes.setExceptionName(GenericException.ERRDEFUTL001.exceptionName());
        exceptionResponse.setError(errorMes);
        return exceptionResponse;
    }
}

