/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.exception.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.giovannilamarmora.utils.exception.dto.ErrorInfo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExceptionResponse
implements Serializable {
    private LocalDateTime dateTime;
    private String url;
    private String correlationId;
    private ErrorInfo error;

    public ExceptionResponse(ErrorInfo error) {
        this.dateTime = this.getDateTime();
        this.error = error;
    }

    public LocalDateTime getDateTime() {
        return LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    }

    public String getUrl() {
        return this.url;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public ErrorInfo getError() {
        return this.error;
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setError(ErrorInfo error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionResponse)) {
            return false;
        }
        ExceptionResponse other = (ExceptionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDateTime this$dateTime = this.getDateTime();
        LocalDateTime other$dateTime = other.getDateTime();
        if (this$dateTime == null ? other$dateTime != null : !((Object)this$dateTime).equals(other$dateTime)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$correlationId = this.getCorrelationId();
        String other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        ErrorInfo this$error = this.getError();
        ErrorInfo other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExceptionResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $dateTime = this.getDateTime();
        result = result * 59 + ($dateTime == null ? 43 : ((Object)$dateTime).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        ErrorInfo $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    public String toString() {
        return "ExceptionResponse(dateTime=" + this.getDateTime() + ", url=" + this.getUrl() + ", correlationId=" + this.getCorrelationId() + ", error=" + this.getError() + ")";
    }

    public ExceptionResponse() {
    }

    public ExceptionResponse(LocalDateTime dateTime, String url, String correlationId, ErrorInfo error) {
        this.dateTime = dateTime;
        this.url = url;
        this.correlationId = correlationId;
        this.error = error;
    }
}

