/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils;

import io.github.giovannilamarmora.utils.generic.Response;
import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.interceptors.Logged;
import io.github.giovannilamarmora.utils.interceptors.correlationID.CorrelationIdUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.LocalDateTime;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Logged
@RestController
@RequestMapping(value={"/v1"})
@CrossOrigin(origins={"*"})
public class HealthCheck {
    @GetMapping(value={"/health-check"}, produces={"application/json"})
    @Tag(name="Health Check", description="API to check if running")
    @Operation(description="API to check if running", tags={"Health Check"})
    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public ResponseEntity<Response> healthCheck() {
        return ResponseEntity.ok((Object)new Response(HttpStatus.OK.value(), LocalDateTime.now() + " the system is ACTIVE.", CorrelationIdUtils.getCorrelationId(), null));
    }
}

