/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.config;

import io.github.giovannilamarmora.utils.config.UtilsPropertiesManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CorsConfig
implements Filter {
    @Autowired
    private UtilsPropertiesManager propertyManager;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.propertyManager.getIsCorsEnabled().booleanValue()) {
            HttpServletResponse response = (HttpServletResponse)res;
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Methods", "POST, PATCH, PUT, GET, OPTIONS, DELETE");
            response.setHeader("Access-Control-Max-Age", "3600");
            response.setHeader("Access-Control-Expose-Headers", "*");
            response.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, Authorization");
            this.LOG.info("Setting Up CORS Policy for mainstream: {}", (Object)response);
        }
        chain.doFilter(req, res);
    }
}

