/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.config;

import io.github.giovannilamarmora.utils.config.ConfigException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UtilsPropertiesManager {
    private static final Logger LOG = LoggerFactory.getLogger(UtilsPropertiesManager.class);
    private final Properties properties = new Properties();
    @Value(value="#{new Integer(${rest.webClient.timeout.read:15000})}")
    private Integer readTimeout;
    @Value(value="#{new Integer(${rest.webClient.timeout.write:15000})}")
    private Integer writeTimeout;
    @Value(value="#{new Integer(${rest.webClient.timeout.connection:10000})}")
    private Integer connectionTimeout;
    @Value(value="#{new Boolean(${app.cors.enabled:false})}")
    private Boolean isCorsEnabled;
    @Value(value="#{new Boolean(${app.exception.stacktrace.utilsException.active:true})}")
    private Boolean isUtilsStackTraceActive;
    @Value(value="#{new Boolean(${app.exception.stacktrace.utilsException.debug:true})}")
    private Boolean isDebugUtilsStackTraceActive;
    @Value(value="#{new Boolean(${app.interceptors.actionType.success.debug:true})}")
    private Boolean isLevelDebugActive;

    public UtilsPropertiesManager() {
        this.loadProperties();
    }

    private void loadProperties() {
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("application.yml");){
            this.properties.load(input);
        }
        catch (IOException e) {
            LOG.error("File not found");
            throw new ConfigException(e.getMessage());
        }
    }

    public Boolean getIsLevelDebugActive() {
        return this.isLevelDebugActive != null ? this.isLevelDebugActive : Boolean.parseBoolean(this.properties.getProperty("app.interceptors.actionType.success.debug", "true"));
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public Integer getWriteTimeout() {
        return this.writeTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Boolean getIsCorsEnabled() {
        return this.isCorsEnabled;
    }

    public Boolean getIsUtilsStackTraceActive() {
        return this.isUtilsStackTraceActive;
    }

    public Boolean getIsDebugUtilsStackTraceActive() {
        return this.isDebugUtilsStackTraceActive;
    }
}

