/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.exception;

import io.github.giovannilamarmora.utils.exception.ExceptionCode;
import org.springframework.http.HttpStatus;

public enum GenericException implements ExceptionCode
{
    ERR_EXC_HAN_001("EXCEPTION_HANDLER", HttpStatus.BAD_REQUEST, "Caught Exception with handler"),
    ERR_DEF_UTL_001("UTILS_EXCEPTION_HANDLER", HttpStatus.BAD_REQUEST, "Caught UtilsException with handler"),
    ERR_EXC_UTL_001("UNABLE_TO_READ_THE_FILE", HttpStatus.BAD_REQUEST, "Unable to read the file"),
    ERR_EXC_UTL_002("ERROR_ON_SETTING_FIELD", HttpStatus.BAD_REQUEST, "Error on setting field"),
    ERR_EXC_UTL_003("INVALID_OBJECT_FIELD", HttpStatus.BAD_REQUEST, "Invalid Object field"),
    ERR_MAT_UTL_001("VALUE_NOT_PERMITTED", HttpStatus.INTERNAL_SERVER_ERROR, "The current value is not permitted"),
    ERR_WEB_CLI_001("WEB_CLIENT_EXCEPTION", HttpStatus.INTERNAL_SERVER_ERROR, "An error occurred during webClient call, body is "),
    ERR_EXC_WEB_001("GENERIC_WEB_EXCEPTION", HttpStatus.BAD_REQUEST, "An error occurred on Web process"),
    ERR_EXC_WEB_002("THREAD_SLEEP_EXCEPTION", HttpStatus.BAD_REQUEST, "An error occurred during thread sleep"),
    ERR_CONF_PRO_001("ERROR_READING_CONFIG", HttpStatus.BAD_REQUEST, "An error occurred during reading proprieties");

    private final HttpStatus status;
    private final String message;
    private final String exception;

    private GenericException(String exception, HttpStatus status, String message) {
        this.exception = exception;
        this.status = status;
        this.message = message;
    }

    @Override
    public String exception() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public HttpStatus getStatus() {
        return this.status;
    }
}

