/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.interceptors;

import io.github.giovannilamarmora.utils.config.UtilsPropertiesManager;
import java.time.Instant;
import org.slf4j.Logger;

public class LogTimeTracker {
    private final ActionType actionType;
    private final String methodName;
    private final String correlationId;
    private final long start;
    private final UtilsPropertiesManager propertiesManager = new UtilsPropertiesManager();

    private LogTimeTracker(ActionType actionType, String methodName, String correlationId) {
        this.actionType = actionType;
        this.methodName = methodName;
        this.correlationId = correlationId;
        this.start = Instant.now().toEpochMilli();
    }

    public static LogTimeTracker startInvocation(ActionType type, String methodName, String correlationId) {
        return new LogTimeTracker(type, methodName, correlationId);
    }

    public void trackFailure(Logger LOG, Exception e) {
        Throwable root_cause = this.getRootCause(e);
        if (root_cause != null) {
            LOG.error("[ACTION_TYPE]={}, [METHOD]={}, [CORRELATION_ID]={}, [TIME_TAKEN]={}, [STATUS]=KO, [EXCEPTION]={}, [DESCRIPTION]={}, [ROOT_EXCEPTION]={}, [ROOT_DESCRIPTION]={}", new Object[]{this.actionType, this.methodName, this.correlationId, this.getDeltaInMilli(), this.getClassName(e), this.getMessage(e), this.getClassName(root_cause), root_cause.getMessage()});
            return;
        }
        LOG.error("[ACTION_TYPE]={}, [METHOD]={}, [CORRELATION_ID]={}, [TIME_TAKEN]={}, [STATUS]=KO, [EXCEPTION]={}, [DESCRIPTION]={}", new Object[]{this.actionType, this.methodName, this.correlationId, this.getDeltaInMilli(), this.getClassName(e), this.getMessage(e)});
    }

    public void trackSuccess(Logger LOG) {
        if (this.actionType.equals((Object)ActionType.DEBUG_MAPPER) || this.isDebugLevel()) {
            LOG.debug("[ACTION_TYPE]={}, [METHOD]={}, [CORRELATION_ID]={}, [TIME_TAKEN]={}, [STATUS]=OK", new Object[]{this.actionType, this.methodName, this.correlationId, this.getDeltaInMilli()});
            return;
        }
        LOG.info("[ACTION_TYPE]={}, [METHOD]={}, [CORRELATION_ID]={}, [TIME_TAKEN]={}, [STATUS]=OK", new Object[]{this.actionType, this.methodName, this.correlationId, this.getDeltaInMilli()});
    }

    private long getDeltaInMilli() {
        return Instant.now().toEpochMilli() - this.start;
    }

    private String getMessage(Exception e) {
        if (e == null) {
            return null;
        }
        return e.getMessage();
    }

    private Throwable getRootCause(Throwable e) {
        if (e == null) {
            return null;
        }
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private String getClassName(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (c == null) {
            return "<null class>";
        }
        return c.getName();
    }

    private boolean isDebugLevel() {
        return !this.actionType.equals((Object)ActionType.APP_CONTROLLER) && !this.actionType.equals((Object)ActionType.CONTROLLER) && !this.actionType.equals((Object)ActionType.APP_SCHEDULER) && !this.actionType.equals((Object)ActionType.SCHEDULER) && this.propertiesManager.getIsLevelDebugActive() != false;
    }

    public static enum ActionType {
        APP_CONTROLLER,
        APP_SERVICE,
        APP_MAPPER,
        DEBUG_MAPPER,
        APP_EXTERNAL,
        APP_CACHE,
        APP_SCHEDULER,
        APP_INTERCEPTOR,
        CONTROLLER,
        SERVICE,
        MAPPER,
        EXTERNAL,
        CACHE,
        SCHEDULER,
        INTERCEPTOR,
        UTILS_LOGGER;

    }
}

