/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.interceptors.correlationID;

import io.github.giovannilamarmora.utils.interceptors.correlationID.CorrelationIdUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class CorrelationIdInterceptor
extends OncePerRequestFilter {
    private static boolean isEmpty(String value) {
        return value == null || value.isBlank();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String correlationId = request.getHeader("X-CorrelationID");
        String mdcCorrelationId = MDC.get((String)"correlationId");
        if (CorrelationIdInterceptor.isEmpty(correlationId) || !correlationId.equalsIgnoreCase(mdcCorrelationId)) {
            MDC.remove((String)"correlationId");
            correlationId = CorrelationIdUtils.generateCorrelationId();
        }
        CorrelationIdUtils.setCorrelationId(correlationId);
        MDC.put((String)"correlationId", (String)CorrelationIdUtils.getCorrelationId());
        response.addHeader("X-CorrelationID", CorrelationIdUtils.getCorrelationId());
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        String path = request.getRequestURI();
        return "/actuator/health".equals(path);
    }
}

