/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.math;

import io.github.giovannilamarmora.utils.exception.UtilsException;
import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.interceptors.Logged;
import io.github.giovannilamarmora.utils.math.MathException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Logged
public class MathService {
    private static final Logger LOG = LoggerFactory.getLogger(MathService.class);

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static double round(double value, int places) throws UtilsException {
        if (places < 0) {
            throw new MathException("The current places: " + places + " is not permitted by the system.");
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

