/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.webClient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.giovannilamarmora.utils.config.UtilsPropertiesManager;
import io.github.giovannilamarmora.utils.webClient.UtilsUriBuilder;
import io.github.giovannilamarmora.utils.webClient.WebClientException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpResponseDecoderSpec;

@Component
public class WebClientRest {
    private static final String END_STRING = "\n";
    private final ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();
    private WebClient webClient;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private String baseUrl;
    private HttpHeaders defaultHeaders;
    @Autowired
    private UtilsPropertiesManager propertyManager;

    public void init(WebClient.Builder builder) {
        this.LOG.info("Initializing WebClient with:");
        if (this.baseUrl != null) {
            builder.baseUrl(this.baseUrl);
            this.LOG.info("BaseUrl: {}", (Object)this.baseUrl);
        }
        if (this.defaultHeaders != null) {
            this.LOG.info("And Default Headers: {}", (Object)this.defaultHeaders.entrySet().stream().toString());
        } else {
            this.defaultHeaders = new HttpHeaders();
            this.defaultHeaders.add("Content-Type", "application/json");
            this.LOG.info("And Default Headers: {}, {}", (Object)"Content-Type", (Object)"application/json");
        }
        HttpClient httpClient = HttpClient.create().httpResponseDecoder(spec -> (HttpResponseDecoderSpec)spec.maxHeaderSize(32768));
        this.webClient = builder.exchangeStrategies(ExchangeStrategies.builder().codecs(this::acceptedCodecs).build()).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }

    public <T> Mono<ResponseEntity<T>> perform(HttpMethod method, UtilsUriBuilder uri, Class<T> returnType) throws JsonProcessingException {
        return this.perform(method, uri, null, null, returnType);
    }

    public <T> Mono<ResponseEntity<T>> perform(HttpMethod method, UtilsUriBuilder uri, Object body, Class<T> returnType) {
        return this.perform(method, uri, body, null, returnType);
    }

    public <T> Mono<ResponseEntity<T>> perform(HttpMethod method, UtilsUriBuilder url, Object body, HttpHeaders headers, Class<T> returnType) {
        StringBuilder logBuilder = new StringBuilder("Performing (").append(method).append(") call with WebClient to the EndPoint: ").append(this.baseUrl != null ? this.baseUrl : "").append(url.getStringUri()).append(END_STRING);
        WebClient.RequestHeadersSpec<?> buildCall = this.buildCall(url, headers, method, body, logBuilder);
        this.LOG.info(logBuilder.toString());
        switch (method) {
            case PUT: 
            case PATCH: 
            case POST: 
            case DELETE: 
            case HEAD: 
            case OPTIONS: 
            case GET: {
                return buildCall.retrieve().onStatus(HttpStatus::isError, clientResponse -> this.handleException((ClientResponse)clientResponse, url.getStringUri(), headers)).toEntity(returnType).map(x -> this.mapResponseEntity((ResponseEntity)x, returnType, headers));
            }
        }
        return Mono.just((Object)ResponseEntity.ok(null));
    }

    private WebClient.RequestHeadersSpec<?> buildCall(UtilsUriBuilder url, HttpHeaders headers, HttpMethod method, Object body, StringBuilder logBuilder) throws WebClientException {
        if (body != null) {
            try {
                logBuilder.append("Body: ").append(this.mapper.writeValueAsString(body)).append(END_STRING);
            }
            catch (JsonProcessingException e) {
                this.LOG.error("An error occurred during deserialize Object, message is {}", (Object)e.getMessage(), (Object)e);
                throw new WebClientException(e.getMessage(), e);
            }
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(method).uri(url.getStringUri(), new Object[0])).headers(this.getDefaultHttpHeaders(headers, logBuilder))).body(BodyInserters.fromValue((Object)body));
        }
        return ((WebClient.RequestBodySpec)this.webClient.method(method).uri(url.getStringUri(), new Object[0])).headers(this.getDefaultHttpHeaders(headers, logBuilder));
    }

    private Consumer<HttpHeaders> getDefaultHttpHeaders(HttpHeaders headerList, StringBuilder logBuilder) {
        if (headerList == null) {
            logBuilder.append("Header: ").append(this.defaultHeaders).append(END_STRING);
            return headers -> headers.putAll((Map)this.defaultHeaders);
        }
        headerList.addIfAbsent((Object)"Content-Type", (Object)"application/json");
        logBuilder.append("Header: ").append(headerList).append(END_STRING);
        return headers -> headers.putAll((Map)headerList);
    }

    private <T> void logReturnSome(HttpStatus code, String headers, String jsonBody) {
        this.LOG.info("Status code: " + code + "\nHeaders: " + headers + "\nBody: " + jsonBody);
    }

    private <T> ResponseEntity<T> mapResponseEntity(ResponseEntity<T> x, Class<T> returnType, HttpHeaders headers) {
        try {
            this.logReturnSome(x.getStatusCode(), x.getHeaders().toString(), this.mapper.writeValueAsString(x.getBody()));
            return x;
        }
        catch (JsonProcessingException e) {
            this.LOG.error("An error occurred during deserialize Object, message is {}", (Object)e.getMessage(), (Object)e);
            throw new WebClientException(e.getMessage(), e);
        }
    }

    private Mono<? extends Throwable> handleException(ClientResponse response, String uri, HttpHeaders headers) {
        List getHeaders = headers.get((Object)"Content-Type");
        if (getHeaders != null && !getHeaders.isEmpty() && (getHeaders.contains("text/xml") || getHeaders.contains("text/plain") || getHeaders.contains("application/x-www-form-urlencoded"))) {
            return response.toEntity(String.class).flatMap(w -> this.flatMapResponse((ResponseEntity)w, uri));
        }
        return response.toEntity(Object.class).flatMap(w -> this.flatMapResponse((ResponseEntity)w, uri));
    }

    private <R> Mono<R> flatMapResponse(ResponseEntity w, String uri) {
        try {
            this.logReturnSome(w.getStatusCode(), w.getHeaders().toString(), this.mapper.writeValueAsString(w.getBody()));
            StringBuilder message = new StringBuilder("An error happened while calling the API: ").append(this.baseUrl != null ? this.baseUrl : "").append(uri).append(", Status Code: ").append(w.getStatusCode()).append(", and body message ").append(w.getBody());
            throw new WebClientException(message.toString());
        }
        catch (JsonProcessingException e) {
            throw new WebClientException(e.getMessage(), e);
        }
    }

    private void acceptedCodecs(ClientCodecConfigurer clientCodecConfigurer) {
        clientCodecConfigurer.customCodecs().register((Object)new Jackson2JsonEncoder(new ObjectMapper(), new MimeType[]{MediaType.TEXT_HTML}));
        clientCodecConfigurer.customCodecs().register((Object)new Jackson2JsonDecoder(new ObjectMapper(), new MimeType[]{MediaType.TEXT_HTML}));
        clientCodecConfigurer.customCodecs().register((Object)new Jackson2JsonEncoder(new ObjectMapper(), new MimeType[]{MediaType.TEXT_PLAIN}));
        clientCodecConfigurer.customCodecs().register((Object)new Jackson2JsonDecoder(new ObjectMapper(), new MimeType[]{MediaType.TEXT_PLAIN}));
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

