/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.config;

import io.github.giovannilamarmora.utils.utilities.FilesUtils;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class OpenAPIConfig {
    private static final Logger LOG = LoggerFactory.getLogger(OpenAPIConfig.class);

    public static PathItem addJSONExamplesOnResource(PathItem pathItem, Class<?> ... optionalClass) {
        if (!ObjectUtils.isEmpty((Object)pathItem.getGet())) {
            OpenAPIConfig.addOperations(pathItem.getGet(), optionalClass);
        }
        if (!ObjectUtils.isEmpty((Object)pathItem.getPost())) {
            OpenAPIConfig.addOperations(pathItem.getPost(), optionalClass);
        }
        if (!ObjectUtils.isEmpty((Object)pathItem.getPatch())) {
            OpenAPIConfig.addOperations(pathItem.getPatch(), optionalClass);
        }
        if (!ObjectUtils.isEmpty((Object)pathItem.getPut())) {
            OpenAPIConfig.addOperations(pathItem.getPut(), optionalClass);
        }
        if (!ObjectUtils.isEmpty((Object)pathItem.getDelete())) {
            OpenAPIConfig.addOperations(pathItem.getDelete(), optionalClass);
        }
        return pathItem;
    }

    private static void addOperations(Operation operation, Class<?> ... optionalClass) {
        if (!ObjectUtils.isEmpty((Object)operation) && !ObjectUtils.isEmpty((Object)operation.getResponses())) {
            operation.getResponses().forEach((statusCode, apiResponse) -> {
                if (!ObjectUtils.isEmpty((Object)apiResponse.getContent()) && !ObjectUtils.isEmpty((Object)apiResponse.getContent().values())) {
                    apiResponse.getContent().values().forEach(content -> {
                        try {
                            if (!content.getExampleSetFlag()) {
                                return;
                            }
                            String fileName = OpenAPIConfig.getExampleFileName(content.getExample().toString());
                            LOG.debug("FileName is {}", (Object)fileName);
                            String jsonContent = FilesUtils.searchFileFromResources(fileName, optionalClass);
                            if (jsonContent != null) {
                                content.setExample((Object)jsonContent);
                            }
                        }
                        catch (Exception e) {
                            LOG.error("An Exception occurred during read filename for Open API", (Throwable)e);
                        }
                    });
                }
            });
        }
    }

    private static String getExampleFileName(String fileName) {
        return fileName.replaceFirst("@", "");
    }
}

