/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.exception;

import io.github.giovannilamarmora.utils.exception.ExceptionCode;
import io.github.giovannilamarmora.utils.exception.GenericException;
import io.github.giovannilamarmora.utils.exception.dto.ErrorInfo;
import io.github.giovannilamarmora.utils.exception.dto.ExceptionResponse;
import io.github.giovannilamarmora.utils.interceptors.correlationID.CorrelationIdUtils;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class UtilsException
extends RuntimeException {
    private ExceptionCode exceptionCode;
    private String exceptionMessage;
    @Value(value="#{new Boolean(${app.exception.stacktrace:true})}")
    private Boolean isUtilsStackTraceActive;
    public static final Logger LOG = LoggerFactory.getLogger(UtilsException.class);

    @ExceptionHandler(value={UtilsException.class})
    private ResponseEntity<ExceptionResponse> handleUtilsException(UtilsException e, HttpServletRequest request) {
        ExceptionResponse error = this.defaultResponse();
        LOG.error("[UtilsException Handler] An error happened while calling {} Downstream API: {}", (Object)request.getRequestURI(), (Object)e.getMessage());
        if (e.exceptionCode != null) {
            ErrorInfo errorMes = new ErrorInfo();
            if (!ObjectUtils.isEmpty((Object)e.exceptionCode.name())) {
                errorMes.setErrorCode(e.exceptionCode.name());
            }
            if (!ObjectUtils.isEmpty((Object)e.exceptionCode.getStatus())) {
                errorMes.setStatus(e.exceptionCode.getStatus());
            }
            error.setUrl(request.getRequestURI());
            if (!ObjectUtils.isEmpty((Object)e.getMessage())) {
                errorMes.setMessage(e.getMessage());
            }
            if (!ObjectUtils.isEmpty((Object)e.getExceptionMessage())) {
                errorMes.setExceptionMessage(e.getExceptionMessage());
            }
            if (this.isUtilsStackTraceActive.booleanValue() && !ObjectUtils.isEmpty((Object[])e.getStackTrace()) && e.getStackTrace().length != 0) {
                errorMes.setStackTrace(Arrays.toString(e.getStackTrace()));
                LOG.error("Stacktrace error: ", (Throwable)e);
            } else if (!this.isUtilsStackTraceActive.booleanValue() && !ObjectUtils.isEmpty((Object[])e.getStackTrace()) && e.getStackTrace().length != 0) {
                LOG.debug("Stacktrace error: ", (Throwable)e);
            }
            if (!ObjectUtils.isEmpty((Object)e.exceptionCode.exception())) {
                errorMes.setException(e.exceptionCode.exception());
            }
            error.setCorrelationId(CorrelationIdUtils.getCorrelationId());
            error.setError(errorMes);
            return new ResponseEntity((Object)error, e.exceptionCode.getStatus());
        }
        LOG.error(Arrays.toString(e.getStackTrace()));
        return new ResponseEntity((Object)error, GenericException.ERR_DEF_UTL_001.getStatus());
    }

    @ExceptionHandler(value={Exception.class})
    private ResponseEntity<ExceptionResponse> handleException(Exception e, HttpServletRequest request) {
        ExceptionResponse error = this.defaultResponse();
        if (!ObjectUtils.isEmpty((Object)e)) {
            LOG.error("[Exception Handler] An error happened while calling {} Downstream API: {}", (Object)request.getRequestURI(), (Object)e.getMessage());
            error = UtilsException.getExceptionResponse(e, request, GenericException.ERR_EXC_HAN_001);
        }
        return new ResponseEntity((Object)error, GenericException.ERR_EXC_HAN_001.getStatus());
    }

    public static ExceptionResponse getExceptionResponse(Exception e, HttpServletRequest request, ExceptionCode exceptionCode) {
        ExceptionResponse exceptionResponse = new ExceptionResponse();
        ErrorInfo errorMes = new ErrorInfo();
        if (!ObjectUtils.isEmpty((Object)e.getClass().getName())) {
            errorMes.setException(e.getClass().getName());
        }
        if (!ObjectUtils.isEmpty((Object)exceptionCode.name())) {
            errorMes.setErrorCode(exceptionCode.name());
        }
        if (!ObjectUtils.isEmpty((Object)exceptionCode.getStatus())) {
            errorMes.setStatus(exceptionCode.getStatus());
        }
        if (!ObjectUtils.isEmpty((Object)e.getMessage())) {
            errorMes.setExceptionMessage(e.getMessage());
        }
        if (!ObjectUtils.isEmpty((Object)request.getRequestURI())) {
            exceptionResponse.setUrl(request.getRequestURI());
        }
        if (!ObjectUtils.isEmpty((Object[])e.getStackTrace())) {
            errorMes.setStackTrace(Arrays.toString(e.getStackTrace()));
            LOG.error("Stacktrace error: ", (Throwable)e);
        }
        exceptionResponse.setCorrelationId(CorrelationIdUtils.getCorrelationId());
        exceptionResponse.setError(errorMes);
        return exceptionResponse;
    }

    private ExceptionResponse defaultResponse() {
        ErrorInfo errorMes = new ErrorInfo(GenericException.ERR_DEF_UTL_001.name(), GenericException.ERR_DEF_UTL_001.exception(), GenericException.ERR_DEF_UTL_001.getStatus(), null, GenericException.ERR_DEF_UTL_001.getMessage(), null);
        return new ExceptionResponse(null, CorrelationIdUtils.getCorrelationId(), errorMes);
    }

    public UtilsException() {
    }

    public UtilsException(ExceptionCode exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public UtilsException(ExceptionCode exceptionCode, String message) {
        super(message);
        this.exceptionCode = exceptionCode;
    }

    public UtilsException(String exceptionMessage, ExceptionCode exceptionCode) {
        this.exceptionCode = exceptionCode;
        this.exceptionMessage = exceptionMessage;
    }

    public UtilsException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, ExceptionCode exceptionCode) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.exceptionCode = exceptionCode;
    }

    public UtilsException(ExceptionCode exceptionCode, String message, String exceptionMessage) {
        super(message);
        this.exceptionCode = exceptionCode;
        this.exceptionMessage = exceptionMessage;
    }

    public ExceptionCode getExceptionCode() {
        return this.exceptionCode;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public Boolean getIsUtilsStackTraceActive() {
        return this.isUtilsStackTraceActive;
    }
}

