/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.web;

import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.interceptors.Logged;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseCookie;
import org.springframework.stereotype.Service;

@Service
@Logged
public class CookieManager {
    private static final Logger LOG = LoggerFactory.getLogger(CookieManager.class);

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void setCookieInResponse(String cookieName, String cookieValue, HttpServletResponse response) {
        LOG.info("Setting Cookie {}, with value {}", (Object)cookieName, (Object)cookieValue);
        ResponseCookie cookie = ResponseCookie.from((String)cookieName, (String)cookieValue).maxAge(360000L).sameSite("None").secure(true).httpOnly(true).path("/").build();
        response.addHeader("Set-Cookie", cookie.toString());
        LOG.debug("Set Cookie {}, with value {}, successfully in Request", (Object)cookieName, (Object)cookieValue);
    }
}

