/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.webClient;

import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import org.springframework.web.util.UriBuilder;

public class UtilsUriBuilder {
    private Function<UriBuilder, URI> uri;
    private String stringUri;

    public Function<UriBuilder, URI> get() {
        return this.uri;
    }

    public static UtilsUriBuilder toBuild() {
        return new UtilsUriBuilder();
    }

    public UtilsUriBuilder set(String path, Map<String, Object> queryParams, Object ... objs) {
        StringBuilder sb = new StringBuilder();
        if (objs != null && objs.length != 0) {
            Object tmp = path;
            for (Object obj : objs) {
                int endIndex = ((String)tmp).indexOf(123);
                String start = ((String)tmp).substring(0, endIndex);
                int beginIndex = ((String)tmp).indexOf(125) + 1;
                String end = ((String)tmp).substring(beginIndex);
                tmp = start + obj + end;
            }
            sb.append((String)tmp);
        } else {
            sb.append(path);
        }
        if (queryParams != null) {
            sb.append("?");
            for (Map.Entry<String, Object> e : queryParams.entrySet()) {
                sb.append(e.getKey()).append("=").append(e.getValue()).append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        this.uri = this.buildWithPath(path, queryParams, objs);
        this.stringUri = sb.toString();
        return this;
    }

    private Function<UriBuilder, URI> buildWithPath(String path, Map<String, Object> queryParams, Object ... objs) {
        return utilsUriBuilder -> {
            utilsUriBuilder.path(path);
            if (queryParams != null) {
                queryParams.entrySet().stream().map(e -> utilsUriBuilder.queryParam((String)e.getKey(), new Object[]{e.getValue()}));
            }
            return utilsUriBuilder.build(objs);
        };
    }

    public String getStringUri() {
        return this.stringUri;
    }
}

