/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.interceptors;

import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
public class UtilsInterceptor
implements WebFilter {
    private static final String MDC_ENV = "environment";
    @Value(value="${env:Default}")
    private String env;

    private static boolean isEmpty(String value) {
        return value == null || value.isBlank();
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String mdcEnv = MDC.get((String)MDC_ENV);
        if (UtilsInterceptor.isEmpty(mdcEnv) || !mdcEnv.equalsIgnoreCase(this.env)) {
            MDC.remove((String)MDC_ENV);
        }
        MDC.put((String)MDC_ENV, (String)this.env);
        return chain.filter(exchange);
    }
}

