/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.interceptors.correlationID;

import io.github.giovannilamarmora.utils.interceptors.correlationID.CorrelationIdUtils;
import org.slf4j.MDC;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
public class CorrelationIdInterceptor
implements WebFilter {
    private static boolean isEmpty(String value) {
        return value == null || value.isBlank();
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.shouldNotFilter(exchange.getRequest())) {
            return chain.filter(exchange);
        }
        String correlationId = exchange.getRequest().getHeaders().getFirst("X-Correlation-ID");
        String mdcCorrelationId = MDC.get((String)"correlationId");
        if (CorrelationIdInterceptor.isEmpty(correlationId) || !correlationId.equalsIgnoreCase(mdcCorrelationId)) {
            MDC.remove((String)"correlationId");
            correlationId = CorrelationIdUtils.generateCorrelationId();
        }
        CorrelationIdUtils.setCorrelationId(correlationId);
        MDC.put((String)"correlationId", (String)CorrelationIdUtils.getCorrelationId());
        exchange.getResponse().getHeaders().add("X-Correlation-ID", CorrelationIdUtils.getCorrelationId());
        return chain.filter(exchange);
    }

    protected boolean shouldNotFilter(ServerHttpRequest request) {
        String path = request.getPath().value();
        return "/actuator/health".equals(path);
    }
}

