/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.web;

import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.interceptors.Logged;
import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

@Service
@Logged
public class CookieManager {
    private static final Logger LOG = LoggerFilter.getLogger(CookieManager.class);

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void setCookieInResponse(String cookieName, String cookieValue, ServerHttpRequest response) {
        LOG.info("Setting Cookie {}, with value {}", (Object)cookieName, (Object)cookieValue);
        ResponseCookie cookie = ResponseCookie.from((String)cookieName, (String)cookieValue).maxAge(360000L).sameSite("None").secure(true).httpOnly(true).path("/").build();
        response.getHeaders().add("Set-Cookie", cookie.toString());
        LOG.debug("Set Cookie {}, with value {}, successfully in Request", (Object)cookieName, (Object)cookieValue);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static HttpHeaders setCookieInResponse(String cookieName, String cookieValue) {
        LOG.info("Setting Cookie {}, with value {}", (Object)cookieName, (Object)cookieValue);
        ResponseCookie cookie = ResponseCookie.from((String)cookieName, (String)cookieValue).maxAge(360000L).sameSite("None").secure(true).httpOnly(true).path("/").build();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Set-Cookie", cookie.toString());
        return headers;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String getCookie(String cookieName, ServerHttpRequest request) {
        LOG.info("Getting Cookie {}", (Object)cookieName);
        MultiValueMap cookies = request.getCookies();
        if (ObjectUtils.isEmpty((Object)cookies) || ObjectUtils.isEmpty((Object)cookies.get((Object)cookieName))) {
            return null;
        }
        return ((HttpCookie)Objects.requireNonNull((List)cookies.get((Object)cookieName)).getFirst()).getValue();
    }
}

