/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.config;

import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@Order(value=-102)
public class CorsConfig
implements WebFilter {
    private final Logger LOG = LoggerFilter.getLogger(this.getClass());
    @Value(value="#{new Boolean(${app.cors.enabled:false})}")
    private Boolean isCorsEnabled;
    @Value(value="${app.cors.shouldNotFilter:**/swagger-ui/**,/api-docs,**/api-docs/**}")
    private List<String> shouldNotFilter;
    @Value(value="${app.cors.allowedOrigins:*}")
    private String allowedOrigins;
    @Value(value="${app.cors.allowedHeaders:*}")
    private String allowedHeaders;
    @Value(value="${app.cors.allowCredentials:true}")
    private Boolean allowCredentials;
    private List<String> allowedOriginsList;

    @PostConstruct
    public void init() {
        this.allowedOriginsList = Arrays.asList(this.allowedOrigins.split(","));
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        if (this.isCorsEnabled.booleanValue() && !this.shouldNotFilter(request)) {
            String requestOrigin = request.getHeaders().getOrigin();
            if (requestOrigin != null && (this.allowedOriginsList.contains("*") || this.allowedOriginsList.contains(requestOrigin))) {
                exchange.getResponse().getHeaders().set("Access-Control-Allow-Origin", requestOrigin);
            } else {
                requestOrigin = "*";
                exchange.getResponse().getHeaders().set("Access-Control-Allow-Origin", requestOrigin);
            }
            exchange.getResponse().getHeaders().set("Access-Control-Allow-Methods", "POST, PATCH, PUT, GET, OPTIONS, DELETE");
            exchange.getResponse().getHeaders().set("Access-Control-Max-Age", "3600");
            exchange.getResponse().getHeaders().set("Access-Control-Allow-Headers", this.allowedHeaders);
            if ("*".equals(requestOrigin) && this.allowCredentials.booleanValue()) {
                this.LOG.debug("CORS: Non \u00e8 possibile usare 'Access-Control-Allow-Origin: *' con 'Access-Control-Allow-Credentials: true'");
            } else if (this.allowCredentials.booleanValue()) {
                exchange.getResponse().getHeaders().set("Access-Control-Allow-Credentials", "true");
            }
            exchange.getResponse().getHeaders().set("Access-Control-Expose-Headers", this.allowedHeaders);
            if (request.getMethod().equals((Object)HttpMethod.OPTIONS)) {
                exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.NO_CONTENT);
            }
            this.LOG.debug("CORS policy set for request from Origin: {}, and Method {}", (Object)requestOrigin, (Object)exchange.getRequest().getMethod());
        }
        return chain.filter(exchange);
    }

    protected boolean shouldNotFilter(ServerHttpRequest req) {
        String path = req.getPath().value();
        String method = req.getMethod().name();
        return this.shouldNotFilter.stream().anyMatch(endpoint -> PatternMatchUtils.simpleMatch((String)endpoint, (String)path));
    }
}

