/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.config;

import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import io.github.giovannilamarmora.utils.web.WebManager;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@Order(value=10)
public class RequestResponseFilter
implements WebFilter {
    private final Logger LOG = LoggerFilter.getLogger(this.getClass());
    @Value(value="${filter.requestResponse.enabled:false}")
    private Boolean requestResponseEnable;
    @Value(value="${filter.requestResponse.shouldNotFilter}")
    private List<String> shouldNotFilter;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (!this.requestResponseEnable.booleanValue()) {
            return chain.filter(exchange);
        }
        if (WebManager.shouldNotFilter(exchange.getRequest(), this.shouldNotFilter)) {
            return chain.filter(exchange);
        }
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        if (this.shouldFilter(exchange.getRequest())) {
            return Mono.defer(() -> {
                this.LOG.info("[REQUEST] Received Request: [{}] {}{}", new Object[]{request.getMethod(), request.getURI(), ObjectUtils.isEmpty((Object)WebManager.getHostFromRequest(request)) ? "" : " from " + WebManager.getHostFromRequest(request)});
                return chain.filter(exchange).then(Mono.fromRunnable(() -> this.LOG.info("[RESPONSE] Sent Response: {} with status {}{}", new Object[]{request.getURI(), response.getStatusCode(), ObjectUtils.isEmpty((Object)WebManager.getHostFromRequest(request)) ? "" : " to " + WebManager.getHostFromRequest(request)})));
            });
        }
        return chain.filter(exchange);
    }

    protected boolean shouldFilter(ServerHttpRequest req) {
        String method = req.getMethod().name();
        return !HttpMethod.OPTIONS.name().equals(method);
    }
}

