/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.context;

import io.github.giovannilamarmora.utils.context.ContextConfig;
import io.github.giovannilamarmora.utils.context.TracingException;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.MDC;

public interface TraceUtils {
    public static final ThreadLocal<String> spanIdTL = ThreadLocal.withInitial(TraceUtils::generateTrace);
    public static final ThreadLocal<String> traceIdTL = ThreadLocal.withInitial(TraceUtils::generateTrace);

    public static String generateTrace() {
        return UUID.randomUUID().toString();
    }

    public static String getSpanID() {
        return Optional.ofNullable(MDC.get((String)ContextConfig.SPAN_ID.getValue())).orElse(Optional.ofNullable(spanIdTL.get()).orElseThrow(() -> new TracingException(ContextConfig.SPAN_ID.getValue() + " has not been initialized")));
    }

    public static String getTraceID() {
        return Optional.ofNullable(MDC.get((String)ContextConfig.TRACE_ID.getValue())).orElse(Optional.ofNullable(traceIdTL.get()).orElseThrow(() -> new TracingException(ContextConfig.TRACE_ID.getValue() + " has not been initialized")));
    }

    public static String getParentID() {
        return Optional.ofNullable(MDC.get((String)ContextConfig.PARENT_ID.getValue())).orElseThrow(() -> new TracingException(ContextConfig.PARENT_ID.getValue() + " has not been initialized"));
    }

    public static String getEnvironment() {
        return Optional.ofNullable(MDC.get((String)ContextConfig.ENV.getValue())).orElseThrow(() -> new TracingException("No " + ContextConfig.ENV.getValue()));
    }
}

