/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.excelObjectMpper;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import io.github.giovannilamarmora.utils.excelObjectMpper.ExcelException;
import io.github.giovannilamarmora.utils.exception.ExceptionCode;
import io.github.giovannilamarmora.utils.exception.GenericException;
import io.github.giovannilamarmora.utils.exception.UtilsException;
import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.interceptors.Logged;
import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Logged
@Service
public class ExcelToObjectMapper {
    private final Logger LOG = LoggerFilter.getLogger(this.getClass());
    private Workbook workbook;

    public ExcelToObjectMapper() {
    }

    public ExcelToObjectMapper(String filePath) throws UtilsException, IOException {
        this.createWorkbook(filePath);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public void createWorkbook(String fileUrl) throws IOException, UtilsException {
        this.LOG.info("Creating workbook for filepath {}", (Object)fileUrl);
        try {
            this.workbook = this.createWorkBook(fileUrl);
        }
        catch (InvalidFormatException e) {
            this.LOG.error("Error on creating workbook for filepath {}", (Object)fileUrl);
            throw new ExcelException("Error during create workbook for file: " + fileUrl, e.getMessage());
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public <T> ArrayList<T> mapClass(Class<T> cls, Integer sheetIndex, Integer rowIndex) throws Exception {
        this.LOG.info("Mapping {} for sheet n {} with header row at {}", new Object[]{cls.getName(), sheetIndex, rowIndex});
        ArrayList<T> list = new ArrayList<T>();
        Sheet sheet = this.workbook.getSheetAt(sheetIndex.intValue());
        int lastRow = sheet.getLastRowNum();
        for (int i = rowIndex + 1; i <= lastRow; ++i) {
            Field[] fields;
            T obj = cls.newInstance();
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                String fieldName = field.getName();
                int index = this.getHeaderIndex(fieldName, this.workbook, sheetIndex, rowIndex);
                Cell cell = sheet.getRow(i).getCell(index);
                Field classField = obj.getClass().getDeclaredField(fieldName);
                this.setObjectFieldValueFromCell(obj, classField, cell);
            }
            list.add(obj);
        }
        this.validate(list);
        return list;
    }

    private void setObjectFieldValueFromCell(Object obj, Field field, Cell cell) throws UtilsException {
        Class<?> cls = field.getType();
        field.setAccessible(true);
        if (cell == null || cell.getCellType() == CellType.BLANK) {
            try {
                field.set(obj, null);
            }
            catch (IllegalAccessException e) {
                this.LOG.error("Error on setting blank cell for field {}", (Object)field.getName());
                throw new ExcelException((ExceptionCode)GenericException.ERR_EXC_UTL_002, "Error on setting blank cell for field: " + field.getName(), e.getMessage());
            }
        } else if (cls == String.class) {
            try {
                field.set(obj, cell.getStringCellValue());
            }
            catch (Exception e) {
                this.LOG.error("Error on getting string cell for field {} with message {}", (Object)field.getName(), (Object)e.getMessage());
                try {
                    field.set(obj, null);
                }
                catch (IllegalAccessException e1) {
                    this.LOG.error("Error on setting null cell for field {}", (Object)field.getName());
                    throw new ExcelException((ExceptionCode)GenericException.ERR_EXC_UTL_002, "Error on setting blank cell for field: " + field.getName(), e1.getMessage());
                }
            }
        } else if (cls == LocalDate.class || cls == LocalDateTime.class) {
            try {
                LocalDateTime value = cell.getLocalDateTimeCellValue();
                if (cls == LocalDate.class) {
                    field.set(obj, value.toLocalDate());
                }
                field.set(obj, value);
            }
            catch (Exception e) {
                this.LOG.error("Error on getting Date cell for field {} with message {}", (Object)field.getName(), (Object)e.getMessage());
                try {
                    field.set(obj, null);
                }
                catch (IllegalAccessException e1) {
                    this.LOG.error("Error on setting null cell for field {}", (Object)field.getName());
                    throw new ExcelException((ExceptionCode)GenericException.ERR_EXC_UTL_002, "Error on setting blank cell for field: " + field.getName(), e1.getMessage());
                }
            }
        } else if (cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == BigDecimal.class) {
            try {
                double value = cell.getNumericCellValue();
                if (cell.getCellStyle().getDataFormatString().contains("%")) {
                    value *= 100.0;
                }
                if (cls == Integer.class) {
                    field.set(obj, (int)value);
                }
                if (cls == Long.class) {
                    field.set(obj, (long)value);
                }
                if (cls == Float.class) {
                    field.set(obj, Float.valueOf((float)value));
                }
                if (cls == BigDecimal.class) {
                    field.set(obj, new BigDecimal(value));
                }
                field.set(obj, value);
            }
            catch (Exception e) {
                this.LOG.error("Error on getting number cell for field {} with message {}", (Object)field.getName(), (Object)e.getMessage());
                try {
                    field.set(obj, null);
                }
                catch (IllegalAccessException e1) {
                    this.LOG.error("Error on setting null cell for field {}", (Object)field.getName());
                    throw new ExcelException((ExceptionCode)GenericException.ERR_EXC_UTL_002, "Error on setting blank cell for field: " + field.getName(), e1.getMessage());
                }
            }
        } else if (cls == Boolean.class) {
            try {
                boolean value = cell.getBooleanCellValue();
                field.set(obj, value);
            }
            catch (Exception e) {
                this.LOG.warn("Error on getting boolean cell for field {} with message {}", (Object)field.getName(), (Object)e.getMessage());
                try {
                    this.LOG.info("Trying to parsing field {} into boolean", (Object)field.getName());
                    String valueParse = cell.getStringCellValue();
                    if (valueParse.equalsIgnoreCase("True") || valueParse.equalsIgnoreCase("Yes")) {
                        field.set(obj, true);
                    }
                    field.set(obj, false);
                }
                catch (Exception e2) {
                    try {
                        field.set(obj, null);
                    }
                    catch (IllegalAccessException e1) {
                        this.LOG.error("Error on setting null cell for field {}", (Object)field.getName());
                        throw new ExcelException((ExceptionCode)GenericException.ERR_EXC_UTL_002, "Error on setting blank cell for field: " + field.getName(), e1.getMessage());
                    }
                }
            }
        } else {
            this.LOG.error("Unsupported Type {}", (Object)cell);
        }
    }

    private Workbook createWorkBook(String file) throws IOException, InvalidFormatException {
        FileInputStream inp = new FileInputStream(file);
        return WorkbookFactory.create((InputStream)inp);
    }

    private int getHeaderIndex(String headerName, Workbook workbook, Integer sheetIndex, Integer rowIndex) throws UtilsException {
        Cell cell;
        String cellValue;
        String headerNameFixed = headerName.replace("_", " ");
        Sheet sheet = workbook.getSheetAt(sheetIndex.intValue());
        int totalColumns = sheet.getRow(rowIndex.intValue()).getLastCellNum();
        int index = -1;
        for (index = 0; index < totalColumns && !(cellValue = (cell = sheet.getRow(rowIndex.intValue()).getCell(index)).getStringCellValue().replace("% ", "").toLowerCase()).equalsIgnoreCase(headerNameFixed) && !cellValue.contains(headerName); ++index) {
        }
        if (index == -1) {
            throw new ExcelException((ExceptionCode)GenericException.ERR_EXC_UTL_003, "Invalid object field name provided.");
        }
        return index;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public <T> void validate(ArrayList<T> excelData) {
    }
}

