/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.exception;

import io.github.giovannilamarmora.utils.context.TraceUtils;
import io.github.giovannilamarmora.utils.exception.ExceptionCode;
import io.github.giovannilamarmora.utils.exception.ExceptionType;
import io.github.giovannilamarmora.utils.exception.GenericException;
import io.github.giovannilamarmora.utils.exception.dto.ErrorInfo;
import io.github.giovannilamarmora.utils.exception.dto.ExceptionResponse;
import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import io.github.giovannilamarmora.utils.utilities.ObjectToolkit;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class UtilsException
extends RuntimeException {
    private ExceptionCode exceptionCode;
    private ExceptionType exception;
    private String exceptionMessage;
    @Value(value="#{new Boolean(${app.exception.stacktrace:true})}")
    private Boolean isUtilsStackTraceActive;
    public static final Logger LOG = LoggerFilter.getLogger(UtilsException.class);

    @ExceptionHandler(value={UtilsException.class})
    private ResponseEntity<ExceptionResponse> handleUtilsException(UtilsException e, ServerHttpRequest request) {
        ExceptionResponse error = this.defaultResponse();
        LOG.error("[UtilsException Handler] An error happened while calling {} Downstream API: {}", (Object)request.getPath().value(), (Object)e.getMessage());
        if (e.exceptionCode != null) {
            ErrorInfo errorMes = new ErrorInfo();
            if (!ObjectUtils.isEmpty((Object)e.exceptionCode.name())) {
                errorMes.setErrorCode(e.exceptionCode.name());
            }
            if (!ObjectUtils.isEmpty((Object)e.exceptionCode.getStatus())) {
                errorMes.setStatus(e.exceptionCode.getStatus());
            }
            error.setUrl(request.getPath().value());
            if (!ObjectUtils.isEmpty((Object)e.getMessage())) {
                errorMes.setMessage(e.getMessage());
            } else if (!ObjectToolkit.isNullOrEmpty(e.exceptionCode.getMessage())) {
                errorMes.setMessage(e.exceptionCode.getMessage());
            }
            if (!ObjectUtils.isEmpty((Object)e.getExceptionMessage())) {
                errorMes.setExceptionMessage(e.getExceptionMessage());
            }
            if (this.isUtilsStackTraceActive.booleanValue() && !ObjectUtils.isEmpty((Object[])e.getStackTrace()) && e.getStackTrace().length != 0) {
                errorMes.setStackTrace(e.getStackTrace()[0].toString());
                LOG.error("Stacktrace error: ", (Throwable)e);
            } else if (!this.isUtilsStackTraceActive.booleanValue() && !ObjectUtils.isEmpty((Object[])e.getStackTrace()) && e.getStackTrace().length != 0) {
                LOG.debug("Stacktrace error: ", (Throwable)e);
            }
            if (!ObjectToolkit.isNullOrEmpty(e.exception)) {
                errorMes.setException(e.exception.name());
            } else if (!ObjectToolkit.isNullOrEmpty(e.exceptionCode.exception())) {
                errorMes.setException(e.exceptionCode.exception());
            }
            error.setSpanId(TraceUtils.getSpanID());
            error.setError(errorMes);
            return new ResponseEntity((Object)error, (HttpStatusCode)e.exceptionCode.getStatus());
        }
        LOG.error(Arrays.toString(e.getStackTrace()));
        return new ResponseEntity((Object)error, (HttpStatusCode)GenericException.ERR_DEF_UTL_001.getStatus());
    }

    @ExceptionHandler(value={Exception.class})
    private ResponseEntity<ExceptionResponse> handleException(Exception e, ServerHttpRequest request) {
        ExceptionResponse error = this.defaultResponse();
        if (!ObjectUtils.isEmpty((Object)e)) {
            LOG.error("[Exception Handler] An error happened while calling {} Downstream API: {}", (Object)request.getPath().value(), (Object)e.getMessage());
            error = UtilsException.getExceptionResponse(e, request, GenericException.ERR_EXC_HAN_001);
        }
        return new ResponseEntity((Object)error, (HttpStatusCode)GenericException.ERR_EXC_HAN_001.getStatus());
    }

    public static ExceptionResponse getExceptionResponse(Exception e, ServerHttpRequest request, ExceptionCode exceptionCode) {
        ExceptionResponse exceptionResponse = new ExceptionResponse();
        ErrorInfo errorMes = new ErrorInfo();
        if (e instanceof UtilsException) {
            if (!ObjectToolkit.isNullOrEmpty(((UtilsException)e).getException())) {
                errorMes.setException(((UtilsException)e).getException().name());
            } else {
                errorMes.setException(((UtilsException)e).getExceptionCode().exception());
            }
        } else if (!ObjectUtils.isEmpty((Object)e.getClass().getName())) {
            errorMes.setException(e.getClass().getName());
        }
        if (!ObjectUtils.isEmpty((Object)exceptionCode.name())) {
            errorMes.setErrorCode(exceptionCode.name());
        }
        if (!ObjectUtils.isEmpty((Object)exceptionCode.getStatus())) {
            errorMes.setStatus(exceptionCode.getStatus());
        }
        if (!ObjectUtils.isEmpty((Object)e.getMessage())) {
            errorMes.setExceptionMessage(e.getMessage());
        }
        if (!ObjectUtils.isEmpty((Object)request.getPath().value())) {
            exceptionResponse.setUrl(request.getPath().value());
        }
        if (!ObjectUtils.isEmpty((Object[])e.getStackTrace())) {
            errorMes.setStackTrace(e.getStackTrace()[0].toString());
            LOG.error("Stacktrace error: ", (Throwable)e);
        }
        exceptionResponse.setSpanId(TraceUtils.getSpanID());
        exceptionResponse.setError(errorMes);
        return exceptionResponse;
    }

    private ExceptionResponse defaultResponse() {
        ErrorInfo errorMes = new ErrorInfo(GenericException.ERR_DEF_UTL_001.name(), GenericException.ERR_DEF_UTL_001.exception(), GenericException.ERR_DEF_UTL_001.getStatus(), null, GenericException.ERR_DEF_UTL_001.getMessage(), null);
        return new ExceptionResponse(null, TraceUtils.getSpanID(), errorMes);
    }

    public UtilsException() {
    }

    public UtilsException(ExceptionCode exceptionCode) {
        this.exceptionCode = exceptionCode;
    }

    public UtilsException(ExceptionCode exceptionCode, String message) {
        super(message);
        this.exceptionCode = exceptionCode;
    }

    public UtilsException(String exceptionMessage, ExceptionCode exceptionCode) {
        this.exceptionCode = exceptionCode;
        this.exceptionMessage = exceptionMessage;
    }

    public UtilsException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, ExceptionCode exceptionCode) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.exceptionCode = exceptionCode;
    }

    public UtilsException(ExceptionCode exceptionCode, String message, String exceptionMessage) {
        super(message);
        this.exceptionCode = exceptionCode;
        this.exceptionMessage = exceptionMessage;
    }

    public UtilsException(ExceptionCode exceptionCode, ExceptionType exception, String message) {
        super(message);
        this.exceptionCode = exceptionCode;
        this.exception = exception;
    }

    public UtilsException(ExceptionCode exceptionCode, ExceptionType exception) {
        this.exceptionCode = exceptionCode;
        this.exception = exception;
    }

    public UtilsException(String message, ExceptionCode exceptionCode, ExceptionType exception, String exceptionMessage) {
        super(message);
        this.exceptionCode = exceptionCode;
        this.exception = exception;
        this.exceptionMessage = exceptionMessage;
    }

    @Generated
    public ExceptionCode getExceptionCode() {
        return this.exceptionCode;
    }

    @Generated
    public ExceptionType getException() {
        return this.exception;
    }

    @Generated
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Generated
    public Boolean getIsUtilsStackTraceActive() {
        return this.isUtilsStackTraceActive;
    }
}

