/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.logger;

import io.github.giovannilamarmora.utils.context.ContextConfig;
import io.github.giovannilamarmora.utils.context.TraceUtils;
import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.micrometer.context.ContextRegistry;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Component
public abstract class MDCUtils {
    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void setDataIntoMDC(String name, String data) {
        if (ObjectUtils.isEmpty((Object)name) || ObjectUtils.isEmpty((Object)data)) {
            return;
        }
        MDC.put((String)name, (String)data);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void registerMDC(String mdcKey) {
        Supplier<String> getMDC = () -> MDC.get((String)mdcKey);
        Consumer<String> putMDC = value -> MDC.put((String)mdcKey, (String)value);
        Runnable removeMDC = () -> MDC.remove((String)mdcKey);
        ContextRegistry.getInstance().registerThreadLocalAccessor(mdcKey, getMDC, putMDC, removeMDC);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void setContextMap(Map<String, String> contextMap) {
        if (contextMap != null) {
            MDC.setContextMap(contextMap);
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static Mono<Void> registerDefaultMDC(String env) {
        return Mono.deferContextual(contextView -> {
            String spanID = "";
            String traceID = "";
            String parentID = "";
            try {
                spanID = TraceUtils.getTraceID();
                MDC.put((String)ContextConfig.TRACE_ID.getValue(), (String)spanID);
            }
            catch (Exception exception) {
                MDC.put((String)ContextConfig.TRACE_ID.getValue(), (String)exception.getMessage());
            }
            try {
                traceID = TraceUtils.getSpanID();
                MDC.put((String)ContextConfig.SPAN_ID.getValue(), (String)traceID);
            }
            catch (Exception exception) {
                MDC.put((String)ContextConfig.SPAN_ID.getValue(), (String)exception.getMessage());
            }
            try {
                parentID = TraceUtils.getParentID();
                MDC.put((String)ContextConfig.PARENT_ID.getValue(), (String)parentID);
            }
            catch (Exception exception) {
                parentID = exception.getMessage();
                MDC.put((String)ContextConfig.PARENT_ID.getValue(), (String)exception.getMessage());
            }
            if (!ObjectUtils.isEmpty((Object)env)) {
                MDC.put((String)ContextConfig.ENV.getValue(), (String)env);
            }
            return Mono.empty().contextWrite((ContextView)Context.of((Object)ContextConfig.TRACE_ID.getValue(), (Object)traceID, (Object)ContextConfig.SPAN_ID.getValue(), (Object)spanID, (Object)ContextConfig.PARENT_ID.getValue(), (Object)parentID, (Object)ContextConfig.ENV.getValue(), (Object)env)).doFinally(signalType -> MDC.clear());
        }).then();
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static ContextView contextViewMDC(String env) {
        String parentID;
        String traceID;
        String spanID;
        try {
            spanID = TraceUtils.getTraceID();
            MDC.put((String)ContextConfig.TRACE_ID.getValue(), (String)spanID);
        }
        catch (Exception exception) {
            spanID = exception.getMessage();
            MDC.put((String)ContextConfig.TRACE_ID.getValue(), (String)spanID);
        }
        try {
            traceID = TraceUtils.getSpanID();
            MDC.put((String)ContextConfig.SPAN_ID.getValue(), (String)traceID);
        }
        catch (Exception exception) {
            traceID = exception.getMessage();
            MDC.put((String)ContextConfig.SPAN_ID.getValue(), (String)traceID);
        }
        try {
            parentID = TraceUtils.getParentID();
            MDC.put((String)ContextConfig.PARENT_ID.getValue(), (String)parentID);
        }
        catch (Exception exception) {
            parentID = exception.getMessage();
            MDC.put((String)ContextConfig.PARENT_ID.getValue(), (String)parentID);
        }
        if (!ObjectUtils.isEmpty((Object)env)) {
            MDC.put((String)ContextConfig.ENV.getValue(), (String)env);
        }
        return Context.of((Object)ContextConfig.TRACE_ID.getValue(), (Object)traceID, (Object)ContextConfig.SPAN_ID.getValue(), (Object)spanID, (Object)ContextConfig.PARENT_ID.getValue(), (Object)parentID, (Object)ContextConfig.ENV.getValue(), (Object)env);
    }
}

