/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.utilities;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.giovannilamarmora.utils.exception.ExceptionCode;
import io.github.giovannilamarmora.utils.exception.GenericException;
import io.github.giovannilamarmora.utils.exception.UtilsException;
import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import io.github.giovannilamarmora.utils.utilities.MapperUtils;
import io.github.giovannilamarmora.utils.utilities.Utilities;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.util.ObjectUtils;

public interface Mapper {
    public static final Logger LOG = LoggerFilter.getLogger(Utilities.class);
    public static final ObjectMapper objectMapper = MapperUtils.mapper().enableJavaTime().indentOutput().disableDateAsTimestamp().emptyStringAsNullObject().failOnEmptyBean().build();

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String writeObjectToString(Object object) {
        if (ObjectUtils.isEmpty((Object)object)) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new UtilsException((ExceptionCode)GenericException.ERR_DEF_UTL_001, "Unable to write json!");
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static <T> T convertValue(T object, Class<T> tClass) {
        if (ObjectUtils.isEmpty(object)) {
            return null;
        }
        try {
            return (T)objectMapper.convertValue(object, tClass);
        }
        catch (IllegalArgumentException e) {
            throw new UtilsException((ExceptionCode)GenericException.ERR_DEF_UTL_001, "Unable to convert value!");
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static <T> T convertValue(T object, TypeReference<T> typeReference) {
        if (ObjectUtils.isEmpty(object)) {
            return null;
        }
        try {
            return (T)objectMapper.convertValue(object, typeReference);
        }
        catch (IllegalArgumentException e) {
            throw new UtilsException((ExceptionCode)GenericException.ERR_DEF_UTL_001, "Unable to convert json!");
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static <T> T convertObject(Object object, Class<T> tClass) {
        if (ObjectUtils.isEmpty((Object)object)) {
            return null;
        }
        try {
            return (T)objectMapper.convertValue(object, tClass);
        }
        catch (IllegalArgumentException e) {
            throw new UtilsException((ExceptionCode)GenericException.ERR_DEF_UTL_001, "Unable to convert value!");
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static <T> T convertObject(Object object, TypeReference<T> typeReference) {
        if (ObjectUtils.isEmpty((Object)object)) {
            return null;
        }
        try {
            return (T)objectMapper.convertValue(object, typeReference);
        }
        catch (IllegalArgumentException e) {
            throw new UtilsException((ExceptionCode)GenericException.ERR_DEF_UTL_001, "Unable to convert json!");
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static <T> T readObject(String objectString, Class<T> tClass) {
        if (ObjectUtils.isEmpty((Object)objectString)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(objectString, tClass);
        }
        catch (JsonProcessingException e) {
            throw new UtilsException((ExceptionCode)GenericException.ERR_DEF_UTL_001, "Unable to read value!");
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static <T> T readObject(String objectString, TypeReference<T> typeReference) {
        if (ObjectUtils.isEmpty((Object)objectString)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(objectString, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new UtilsException((ExceptionCode)GenericException.ERR_DEF_UTL_001, "Unable to read json!");
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static JsonNode readTree(String objectString) {
        if (ObjectUtils.isEmpty((Object)objectString)) {
            return null;
        }
        try {
            return objectMapper.readTree(objectString);
        }
        catch (JsonProcessingException e) {
            throw new UtilsException((ExceptionCode)GenericException.ERR_DEF_UTL_001, "Unable to read value!");
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static JsonNode readTree(Map<String, Object> objectMap) {
        if (objectMap == null || objectMap.isEmpty()) {
            return null;
        }
        try {
            return objectMapper.valueToTree(objectMap);
        }
        catch (Exception e) {
            throw new UtilsException((ExceptionCode)GenericException.ERR_DEF_UTL_001, "Unable to read value!");
        }
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static JsonNode removeField(JsonNode originalNode, String fieldName) {
        if (originalNode.isObject()) {
            ObjectNode newNode = (ObjectNode)originalNode.deepCopy();
            newNode.remove(fieldName);
            return newNode;
        }
        return originalNode;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String convertMapToString(Map<String, ?> map) {
        if (ObjectUtils.isEmpty(map)) {
            return null;
        }
        return map.keySet().stream().map(key -> "\"" + key + "\": \"" + String.valueOf(map.get(key)) + "\"").collect(Collectors.joining(", ", "{", "}"));
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static Map<String, Object> deleteKeyFromMap(Map<String, Object> map, String key) {
        String[] keys = key.split("\\.");
        Mapper.removeNestedKey(map, keys, 0);
        return map;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static Map<String, Object> deleteKeysFromMap(Map<String, Object> map, List<String> keys) {
        for (String key : keys) {
            String[] keyParts = key.split("\\.");
            Mapper.removeNestedKey(map, keyParts, 0);
        }
        return map;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    private static void removeNestedKey(Map<String, Object> map, String[] keys, int index) {
        if (index == keys.length - 1) {
            map.remove(keys[index]);
            return;
        }
        Object nextLevel = map.get(keys[index]);
        if (nextLevel instanceof Map) {
            Mapper.removeNestedKey((Map)nextLevel, keys, index + 1);
            if (((Map)nextLevel).isEmpty()) {
                map.remove(keys[index]);
            }
        }
    }
}

