/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.utilities;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.utilities.Mapper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.ObjectUtils;

public interface ObjectToolkit {
    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static Map<String, String> getFinalMapFromValue(Map<String, String> source, Map<String, String> target) {
        HashMap<String, String> finalParam = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("\\{\\{(.+?)\\}\\}");
        for (Map.Entry<String, String> entry : target.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Matcher matcher = pattern.matcher(value);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                String placeholder = matcher.group(1);
                String replacement = source.getOrDefault(placeholder, matcher.group(0));
                if (ObjectUtils.isEmpty((Object)replacement)) continue;
                matcher.appendReplacement(result, replacement);
            }
            matcher.appendTail(result);
            finalParam.put(key, result.toString());
        }
        return finalParam;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static boolean fieldsNullOrEmpty(Object obj) {
        Field[] fields;
        if (ObjectUtils.isEmpty((Object)obj)) {
            return true;
        }
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (field.get(obj) == null) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                return true;
            }
        }
        return true;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static <T> boolean isInstanceOf(String source, TypeReference<T> typeReference) {
        return !ObjectToolkit.fieldsNullOrEmpty(Mapper.readObject(source, typeReference));
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static boolean isNullOrEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Optional.class, CharSequence.class, Collection.class, Map.class}, (Object)object2, n)) {
            case 0 -> {
                Optional optional = (Optional)object2;
                yield optional.isEmpty();
            }
            case 1 -> {
                CharSequence charSequence = (CharSequence)object2;
                yield charSequence.isEmpty();
            }
            case 2 -> {
                Collection collection = (Collection)object2;
                yield collection.isEmpty();
            }
            case 3 -> {
                Map map = (Map)object2;
                yield map.isEmpty();
            }
            default -> obj.getClass().isArray() && Array.getLength(obj) == 0;
        };
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static <E extends Enum<E>> boolean isEnumValue(String value, Class<E> enumClass) {
        try {
            Enum.valueOf(enumClass, value);
            return true;
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return false;
        }
    }

    public static <T, R> R getValueOrNull(T obj, Function<T, R> getter) {
        R value = getter.apply(obj);
        return ObjectToolkit.isNullOrEmpty(value) ? null : (R)value;
    }

    public static <T, R> R getValueOrDefault(T obj, Function<T, R> getter, R defaultValue) {
        R value = getter.apply(obj);
        return ObjectToolkit.isNullOrEmpty(value) ? defaultValue : value;
    }

    public static <R> R getOrDefault(R value, R defaultValue) {
        return ObjectToolkit.isNullOrEmpty(value) ? defaultValue : value;
    }

    public static boolean areNotNullOrEmptyCast(Object obj, Function<?, ?> ... getters) {
        if (ObjectToolkit.isNullOrEmpty(obj)) {
            return false;
        }
        Object currentValue = obj;
        for (Function<?, ?> getter : getters) {
            Function<?, ?> func = getter;
            if (!ObjectToolkit.isNullOrEmpty(currentValue = func.apply(currentValue))) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static boolean areNotNullOrEmpty(Object obj, Function<Object, Object> ... getters) {
        if (ObjectToolkit.isNullOrEmpty(obj)) {
            return false;
        }
        Object currentValue = obj;
        for (Function<Object, Object> getter : getters) {
            if (!ObjectToolkit.isNullOrEmpty(currentValue = getter.apply(currentValue))) continue;
            return false;
        }
        return true;
    }

    public static boolean areNullOrEmptyCast(Object obj, Function<?, ?> ... getters) {
        if (ObjectToolkit.isNullOrEmpty(obj)) {
            return true;
        }
        Object currentValue = obj;
        for (Function<?, ?> getter : getters) {
            Function<?, ?> func = getter;
            if (!ObjectToolkit.isNullOrEmpty(currentValue = func.apply(currentValue))) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean areNullOrEmpty(Object obj, Function<Object, Object> ... getters) {
        if (ObjectToolkit.isNullOrEmpty(obj)) {
            return true;
        }
        Object currentValue = obj;
        for (Function<Object, Object> getter : getters) {
            if (!ObjectToolkit.isNullOrEmpty(currentValue = getter.apply(currentValue))) continue;
            return true;
        }
        return false;
    }

    public static <T> Function<Object, Object> lift(Function<T, ?> f) {
        return o -> f.apply(o);
    }
}

