/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.web;

import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.interceptors.Logged;
import io.github.giovannilamarmora.utils.logger.LoggerFilter;
import io.github.giovannilamarmora.utils.web.WebManager;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

@Service
@Logged
public interface CookieManager {
    public static final Logger LOG = LoggerFilter.getLogger(CookieManager.class);

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void setCookieInResponse(String cookieName, String cookieValue, ServerHttpResponse response, ServerHttpRequest request) {
        String referer = request.getHeaders().getFirst("Referer");
        String origin = request.getHeaders().getFirst("Origin");
        String host = request.getHeaders().getFirst("Host");
        String url = origin != null && !origin.equals("*") ? origin : (host != null ? host : referer);
        String domain = WebManager.extractDomain(url);
        ResponseCookie.ResponseCookieBuilder cookieBuilder = ResponseCookie.from((String)cookieName, (String)cookieValue).maxAge(360000L).sameSite("None").secure(true).httpOnly(true).path("/");
        if (domain != null) {
            cookieBuilder.domain(domain);
        }
        response.getHeaders().add("Set-Cookie", cookieBuilder.build().toString());
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void setCookieInResponse(String cookieName, String cookieValue, ServerHttpResponse response) {
        ResponseCookie cookie = ResponseCookie.from((String)cookieName, (String)cookieValue).maxAge(360000L).sameSite("None").secure(true).httpOnly(true).path("/").build();
        response.getHeaders().add("Set-Cookie", cookie.toString());
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void setCookieInResponse(String cookieName, String cookieValue, String domain, ServerHttpResponse response) {
        ResponseCookie cookie = ResponseCookie.from((String)cookieName, (String)cookieValue).domain(domain).maxAge(360000L).sameSite("None").secure(true).httpOnly(true).path("/").build();
        response.getHeaders().add("Set-Cookie", cookie.toString());
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static ResponseCookie setCookie(String cookieName, String cookieValue) {
        return ResponseCookie.from((String)cookieName, (String)cookieValue).maxAge(360000L).sameSite("None").secure(true).httpOnly(true).path("/").build();
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static ResponseCookie setCookie(String cookieName, String cookieValue, String domain) {
        return ResponseCookie.from((String)cookieName, (String)cookieValue).domain(domain).maxAge(360000L).sameSite("None").secure(true).httpOnly(true).path("/").build();
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static HttpHeaders setCookieInResponse(String cookieName, String cookieValue) {
        ResponseCookie cookie = ResponseCookie.from((String)cookieName, (String)cookieValue).maxAge(360000L).sameSite("None").secure(true).httpOnly(true).path("/").build();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Set-Cookie", cookie.toString());
        return headers;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static HttpHeaders setCookieInResponse(String cookieName, String cookieValue, String domain) {
        ResponseCookie cookie = ResponseCookie.from((String)cookieName, (String)cookieValue).domain(domain).maxAge(360000L).sameSite("None").secure(true).httpOnly(true).path("/").build();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Set-Cookie", cookie.toString());
        return headers;
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static String getCookie(String cookieName, ServerHttpRequest request) {
        LOG.debug("Getting Cookie {}", (Object)cookieName);
        MultiValueMap cookies = request.getCookies();
        if (ObjectUtils.isEmpty((Object)cookies) || ObjectUtils.isEmpty((Object)cookies.get((Object)cookieName))) {
            return null;
        }
        return ((HttpCookie)Objects.requireNonNull((List)cookies.get((Object)cookieName)).getFirst()).getValue();
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void deleteCookie(String cookieName, ServerHttpResponse response) {
        LOG.debug("Deleting Cookie {}", (Object)cookieName);
        ResponseCookie cookieToDelete = ResponseCookie.from((String)cookieName, (String)"").maxAge(Duration.ofSeconds(0L)).path("/").build();
        response.addCookie(cookieToDelete);
        LOG.debug("Cookie {} deleted", (Object)cookieName);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void deleteCookie(String cookieName, ServerHttpRequest request, ServerHttpResponse response) {
        LOG.debug("Deleting Cookie {}", (Object)cookieName);
        MultiValueMap cookies = request.getCookies();
        if (ObjectUtils.isEmpty((Object)cookies) || ObjectUtils.isEmpty((Object)cookies.get((Object)cookieName))) {
            LOG.debug("Cookie {} not found", (Object)cookieName);
            return;
        }
        ResponseCookie cookieToDelete = ResponseCookie.from((String)cookieName, (String)"").maxAge(Duration.ofSeconds(0L)).path("/").build();
        response.addCookie(cookieToDelete);
        LOG.debug("Cookie {} deleted", (Object)cookieName);
    }
}

