/*
 * Decompiled with CFR 0.152.
 */
package io.github.giovannilamarmora.utils.web;

import io.github.giovannilamarmora.utils.interceptors.LogInterceptor;
import io.github.giovannilamarmora.utils.interceptors.LogTimeTracker;
import io.github.giovannilamarmora.utils.web.CookieManager;
import io.github.giovannilamarmora.utils.web.HeaderManager;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;

public interface ResponseManager {
    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void setCookieAndHeaderData(String headerName, String headerValue, ServerHttpResponse response) {
        HeaderManager.addOrSetHeaderInResponse(headerName, headerValue, response);
        CookieManager.setCookieInResponse(headerName, headerValue, response);
    }

    @LogInterceptor(type=LogTimeTracker.ActionType.UTILS_LOGGER)
    public static void setCookieAndHeaderData(String headerName, String headerValue, ServerHttpResponse response, ServerHttpRequest request) {
        HeaderManager.addOrSetHeaderInResponse(headerName, headerValue, response);
        CookieManager.setCookieInResponse(headerName, headerValue, response, request);
    }
}

